/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.service;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorFactory;
import com.pageseeder.service.Service;
import com.pageseeder.service.ServiceRegistry;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.furi.URIPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

final class ServicesHandler10
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServicesHandler10.class);
    private final GeneratorFactory factory;
    private final ServiceRegistry registry;
    private transient @Nullable URIPattern pattern;
    private transient @Nullable Service.HttpMethod method;
    private transient @Nullable String cacheControl;
    private transient @Nullable String resourceId;
    private transient @Nullable Generator generator;
    private transient @Nullable Map<String, String> parameters;
    private transient @Nullable List<String> parameterTunnels;
    private @Nullable String since = null;
    private @Nullable String deprecated = null;
    private @Nullable String obsolete = null;

    public ServicesHandler10(ServiceRegistry registry, GeneratorFactory factory) {
        this.registry = registry;
        this.factory = factory;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        Element element = Element.get(localName);
        if (element == null) {
            return;
        }
        switch (element) {
            case GENERATOR: {
                if (this.obsolete != null) break;
                this.generator = this.factory.getInstance(atts.getValue("class"));
                break;
            }
            case PARAMETER: {
                if (this.parameters == null) {
                    this.parameters = new LinkedHashMap<String, String>();
                }
                this.parameters.put(atts.getValue("name"), atts.getValue("value"));
                break;
            }
            case PARAMETER_TUNNEL: {
                if (this.parameterTunnels == null) {
                    this.parameterTunnels = new LinkedList<String>();
                }
                this.parameterTunnels.add(atts.getValue("prefix"));
                break;
            }
            case METHOD: {
                this.method = Service.HttpMethod.valueOf(atts.getValue("type").toUpperCase());
                this.since = atts.getValue("since");
                this.deprecated = atts.getValue("deprecated");
                this.obsolete = atts.getValue("obsolete");
                break;
            }
            case RESOURCE: {
                this.pattern = new URIPattern(atts.getValue("path"));
                this.cacheControl = atts.getValue("cache-control");
                this.resourceId = atts.getValue("id");
                break;
            }
            case SERVICES: {
                this.registry.clear();
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        Element element = Element.get(localName);
        if (Objects.requireNonNull(element) == Element.METHOD) {
            if (this.pattern == null || this.method == null || this.generator == null || this.resourceId == null) {
                LOGGER.warn("Incomplete service definition: pattern={}, method={}, generator={}, id={}", new Object[]{this.pattern, this.method, this.generator, this.resourceId});
            } else {
                Service.Builder builder = new Service.Builder(this.pattern, this.method, this.generator);
                builder.resource(this.resourceId);
                if (this.parameters != null) {
                    builder.parameters(this.parameters);
                }
                if (this.parameterTunnels != null) {
                    builder.parameterTunnels(this.parameterTunnels);
                }
                if (this.cacheControl != null) {
                    builder.cacheControl(this.cacheControl);
                }
                builder.since(this.since);
                builder.deprecated(this.deprecated);
                builder.obsolete(this.obsolete);
                Service service = builder.build();
                LOGGER.debug("Registering {}", (Object)service);
                this.registry.register(service);
            }
            this.parameters = null;
            this.cacheControl = null;
            this.since = null;
            this.deprecated = null;
            this.obsolete = null;
        }
    }

    private static enum Element {
        GENERATOR,
        PARAMETER,
        PARAMETER_TUNNEL,
        METHOD,
        RESOURCE,
        SERVICES;

        private final String name = this.name().toLowerCase().replace('_', '-');

        public static @Nullable Element get(String name) {
            for (Element element : Element.values()) {
                if (!element.name.equals(name)) continue;
                return element;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }
}

