/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.service;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.GenericBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.furi.URIPattern;
import org.slf4j.LoggerFactory;

public final class Service {
    private static final int CURRENT_VERSION;
    private final URIPattern pattern;
    private final HttpMethod method;
    private final Generator generator;
    private final Map<String, String> parameters;
    private final List<String> parametertunnels;
    private final String cacheControl;
    private final String resourceId;
    private final int since;
    private final int deprecated;
    private final int obsolete;

    Service(Builder builder) {
        this.pattern = builder.pattern;
        this.method = builder.method;
        this.generator = builder.generator;
        this.cacheControl = builder.cacheControl;
        this.parameters = builder.parameters;
        this.parametertunnels = builder.parameterTunnels;
        this.resourceId = builder.resourceId;
        this.since = builder.since;
        this.deprecated = builder.deprecated;
        this.obsolete = builder.obsolete;
    }

    public URIPattern pattern() {
        return this.pattern;
    }

    public HttpMethod method() {
        return this.method;
    }

    public Generator generator() {
        return this.generator;
    }

    public List<OutputType> outputTypes() {
        Output o = this.generator.getClass().getAnnotation(Output.class);
        if (o != null) {
            OutputType[] types = o.types();
            return Arrays.asList(types);
        }
        return Collections.singletonList(OutputType.XML);
    }

    public Map<String, String> parameters() {
        return this.parameters;
    }

    public List<String> parameterTunnels() {
        return this.parametertunnels;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public String getResourceID() {
        return this.resourceId;
    }

    public String getSince() {
        return Service.format(this.since);
    }

    public String getDeprecated() {
        return Service.format(this.deprecated);
    }

    public String getObsolete() {
        return Service.format(this.obsolete);
    }

    public boolean isVersion(String version) {
        int v = Service.toVersion(version, CURRENT_VERSION);
        return v >= this.since && v < this.obsolete;
    }

    public boolean isObsolete(String version) {
        int v = Service.toVersion(version, CURRENT_VERSION);
        return v >= this.obsolete;
    }

    public boolean isDeprecated() {
        return CURRENT_VERSION >= this.deprecated;
    }

    public boolean isObsolete() {
        return CURRENT_VERSION >= this.obsolete;
    }

    public boolean isDeprecated(@Nullable String version) {
        int v = Service.toVersion(version, CURRENT_VERSION);
        return v >= this.deprecated;
    }

    public boolean isSince(@Nullable String version) {
        int v = Service.toVersion(version, CURRENT_VERSION);
        return v >= this.since;
    }

    public String toString() {
        return String.valueOf(this.pattern) + " " + String.valueOf((Object)this.method) + " - " + String.valueOf(this.generator.getClass());
    }

    public static int toVersion(@Nullable String version, int fallback) {
        if (version == null) {
            return fallback;
        }
        try {
            boolean integration;
            String v = version.replaceAll("[^\\d.]", "");
            boolean bl = integration = v.length() > 6;
            if (integration) {
                return Math.round(Float.parseFloat(v.substring(0, 6)) * 10000.0f);
            }
            return Math.round(Float.parseFloat(v) * 10000.0f);
        }
        catch (NumberFormatException ex) {
            LoggerFactory.getLogger(Service.class).warn("Invalid version number {}", (Object)version);
            return fallback;
        }
    }

    private static String format(int version) {
        return version / 10000 + "." + version % 10000;
    }

    static {
        int version = 59000;
        try {
            version = Service.toVersion(Settings.getPageSeederVersion(), 0);
        }
        catch (NullPointerException nullPointerException) {
        }
        finally {
            CURRENT_VERSION = version;
        }
    }

    static final class Builder
    implements GenericBuilder<Service> {
        private final URIPattern pattern;
        private final HttpMethod method;
        private final Generator generator;
        private Map<String, String> parameters = Collections.emptyMap();
        private List<String> parameterTunnels = Collections.emptyList();
        private String cacheControl = "no-cache";
        private @Nullable String resourceId;
        private int since = 0;
        private int deprecated = Integer.MAX_VALUE;
        private int obsolete = Integer.MAX_VALUE;

        public Builder(URIPattern p, HttpMethod m, Generator g) {
            this.pattern = Objects.requireNonNull(p);
            this.method = Objects.requireNonNull(m);
            this.generator = Objects.requireNonNull(g);
        }

        public Builder parameters(@Nullable Map<String, String> parameters) {
            if (parameters != null) {
                this.parameters = Collections.unmodifiableMap(parameters);
            }
            return this;
        }

        public Builder parameterTunnels(@Nullable List<String> tunnels) {
            if (tunnels != null) {
                this.parameterTunnels = Collections.unmodifiableList(tunnels);
            }
            return this;
        }

        public Builder cacheControl(@Nullable String cacheControl) {
            this.cacheControl = Objects.toString(cacheControl, "no-cache");
            return this;
        }

        public Builder resource(String id) {
            this.resourceId = id;
            return this;
        }

        public Builder since(@Nullable String version) {
            this.since = Service.toVersion(version, 0);
            return this;
        }

        public Builder deprecated(@Nullable String version) {
            this.deprecated = Service.toVersion(version, Integer.MAX_VALUE);
            return this;
        }

        public Builder obsolete(@Nullable String version) {
            this.obsolete = Service.toVersion(version, Integer.MAX_VALUE);
            return this;
        }

        public Service build() {
            if (this.resourceId == null) {
                throw new IllegalStateException("No resource ID specified for service");
            }
            return new Service(this);
        }
    }

    public static enum HttpMethod {
        GET,
        PATCH,
        POST,
        PUT,
        DELETE;

    }
}

