/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

final class URLEncoder {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int MAX_BYTES_PER_CHAR = 10;
    private final BitSet safeCharacters = new BitSet(256);

    public URLEncoder() {
        char i;
        for (i = 'a'; i <= 'z'; i = (char)((char)(i + '\u0001'))) {
            this.addSafeCharacter(i);
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
        for (i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            this.addSafeCharacter(i);
        }
    }

    public void addSafeCharacter(char c) {
        this.safeCharacters.set(c);
    }

    public String encode(String path) {
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(10);
        OutputStreamWriter writer = null;
        writer = new OutputStreamWriter((OutputStream)buf, StandardCharsets.UTF_8);
        for (int i = 0; i < path.length(); ++i) {
            byte[] ba;
            char c = path.charAt(i);
            if (this.safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            for (byte toEncode : ba = buf.toByteArray()) {
                rewrittenPath.append('%');
                int low = toEncode & 0xF;
                int high = (toEncode & 0xF0) >> 4;
                rewrittenPath.append(HEX[high]);
                rewrittenPath.append(HEX[low]);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }
}

