/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.publish.PublishEvent;
import com.pageseeder.publish.PublishScheduler;
import java.io.File;
import java.io.IOException;

@Output(types={OutputType.JSON, OutputType.XML})
public final class PublishSchedulerEvents
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        if ("true".equals(req.getParameter("reload-schedule"))) {
            PublishScheduler.reloadAllEvents(new File(req.getHttpServletRequest().getServletContext().getRealPath("/WEB-INF")));
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("schedule");
        out.startCollection("events", OutputPrinter.CollectionOption.JSON_ONLY);
        for (PublishEvent event : PublishScheduler.getInstance().getEvents()) {
            event.print((OutputPrinter)out);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

