/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.common.util.ISO8601;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class PublishJobDetails
implements XMLWritable,
UniversallyPrintable {
    private final String _id;
    private final String _uriPath;
    private final String _username;
    private final String _groupname;
    private final long _started;
    private String currentStatus = null;
    private String currentMessage = null;

    public PublishJobDetails(String id, long start, String path, String user, String group) {
        this._id = id;
        this._started = start;
        this._uriPath = path;
        this._username = user;
        this._groupname = group;
    }

    public void setCurrentMessage(String message) {
        this.currentMessage = message;
    }

    public void setCurrentStatus(String status) {
        this.currentStatus = status;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("job");
        xml.attribute("id", this._id);
        xml.attribute("username", this._username);
        xml.attribute("group", this._groupname);
        xml.attribute("started", ISO8601.DATETIME.format(this._started));
        xml.attribute("path", this._uriPath);
        if (this.currentMessage != null) {
            xml.attribute("message", this.currentMessage);
        }
        if (this.currentStatus != null) {
            xml.attribute("status", this.currentStatus);
        }
        xml.closeElement();
    }

    public void print(OutputPrinter out) {
        out.startObject("job");
        out.field("id", this._id);
        out.field("username", this._username);
        out.field("group", this._groupname);
        out.field("started", ISO8601.DATETIME.format(this._started));
        out.field("path", this._uriPath);
        if (this.currentMessage != null) {
            out.field("message", this.currentMessage);
        }
        if (this.currentStatus != null) {
            out.field("status", this.currentStatus);
        }
        out.endObject();
    }

    public String id() {
        return this._id;
    }

    public boolean isCompleted() {
        return "complete".equals(this.currentStatus) || "cancel".equals(this.currentStatus) || "error".equals(this.currentStatus) || "fail".equals(this.currentStatus);
    }

    public String getStatus() {
        return this.currentStatus;
    }

    public String getUsername() {
        return this._username;
    }

    public String getGroup() {
        return this._groupname;
    }
}

