/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.MembershipCache;
import com.pageseeder.base.security.AccountLockout;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.db.model.Member;
import java.io.IOException;

@Requires(database=true, member=true)
@Output(types={OutputType.JSON, OutputType.XML})
@PublicAPI
public final class UnlockMember
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageAccountCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Member member = req.getMember();
        assert (member != null);
        AccountLockout.unlockLogin((String)member.getUsername());
        AccountLockout.unlockLogin((String)member.getEmail());
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("member-unlock");
        out.writeMember(member);
        out.endObject();
        new MembershipCache().remove(member.getId());
    }
}

