/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.member.MemberErrorID;
import java.io.IOException;
import java.util.Collection;

@Requires(database=true)
@Output(types={OutputType.JSON, OutputType.XML})
@PublicAPI
public final class SendActivationNotification
implements Generator,
SingleCheck {
    @ContentPermission(value=NoCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new NoCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Member mem;
        Database db = req.getDatabase();
        String email = req.getParameter((Parameter)StandardParameters.email, "");
        String username = req.getParameter((Parameter)StandardParameters.member_username, "");
        if (username.isEmpty() && email.isEmpty()) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USERNAME_OR_EMAIL_REQUIRED);
            return;
        }
        if (!email.isEmpty() && !Emails.isAddress((String)email)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_EMAIL);
            return;
        }
        Collection members = DatabaseQuery.getMembersByUsernameEmailNameList((Database)db, (int)1, (int)1, (String)username, (String)email, (String)"", (String)"");
        Member member = mem = members.isEmpty() ? null : (Member)members.iterator().next();
        if (mem == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NO_MATCHING_MEMBER);
            return;
        }
        if (mem.getEmail() == null || mem.getEmail().isEmpty() || "No Email".equals(mem.getEmail())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_HAS_NO_EMAIL);
            return;
        }
        if (MemberRule.isMemberActivated((Member)mem)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_ALREADY_ACTIVE);
            return;
        }
        try {
            Emails.sendNewMember((Database)db, (Member)mem, (Group)req.getGroup(), null, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
            UniversalPrinter out = res.getUniversalWriter();
            out.startObject("member-activation");
            out.field("email", mem.getEmail());
            out.endObject();
            out.flush();
        }
        catch (EmailException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)MemberErrorID.UNABLE_TO_SEND_ACTIVATION);
            req.getLogger((Object)this).error("Unable to send activation email", (Throwable)ex);
        }
    }
}

