/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.mfa.totp.TOTP;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.Authenticators;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.PNG, OutputType.TEXT})
@PublicAPI(value=PublicAPI.Support.EXPERIMENTAL)
public class QRServlet
extends HttpServlet {
    private static final long serialVersionUID = -6743554136164631004L;
    private static final Logger LOGGER = LoggerFactory.getLogger(QRServlet.class);

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        WebRequest wr = new WebRequest(req, res);
        String authId = wr.getParameter("authenticator", "");
        if (authId.isEmpty()) {
            wr.sendError(400, "Unspecified authenticator");
            return;
        }
        Database db = wr.getDatabase();
        try (Database database = db;){
            if (db == null) {
                return;
            }
            Permissions perm = new Permissions();
            if (!PermissionManager.check((HttpServletRequest)req, (HttpServletResponse)res, (Database)db, (Permissions)perm, (PermissionCheck)new AuthenticatedInternalCheck())) {
                return;
            }
            Long memberId = perm.getMemberId();
            if (memberId == null) {
                wr.sendError(400, "Invalid or unknown member");
                return;
            }
            Member member = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
            if (member == null) {
                wr.sendError(400, "Invalid or unknown member");
                return;
            }
            Authenticator authenticator = Authenticators.getUnverifiedAuthenticator((Database)db, (long)memberId, (String)authId);
            if (authenticator == null) {
                wr.sendError(400, "No authenticator requiring verification found");
                return;
            }
            if (!"totp".equals(authenticator.getType())) {
                wr.sendError(400, "Specified authenticator type does not support QR codes");
                return;
            }
            String issuer = GlobalSettings.get((String)"webSiteAddress");
            assert (issuer != null);
            String account = member.getEmail();
            if ("No Email".equals(account)) {
                account = member.getUsername();
            }
            String otpUrl = TOTP.getAuthenticatorOTPAuthURL((Authenticator)authenticator, (String)account, (String)issuer);
            if (req.getRequestURI().endsWith(".txt")) {
                res.setContentType("text/plain");
                res.getWriter().write(otpUrl);
                res.flushBuffer();
            } else {
                this.writeQRImage(res, otpUrl, wr);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to generate the QR code for authenticator: {}", (Object)ex.getMessage(), (Object)ex);
            wr.sendError(500, "Unable to generate the QR code for authenticator");
        }
    }

    private void writeQRImage(HttpServletResponse res, String otpUrl, WebRequest wr) throws IOException {
        try {
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix bitMatrix = qrCodeWriter.encode(otpUrl, BarcodeFormat.QR_CODE, 200, 200);
            res.setContentType("image/png");
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)res.getOutputStream());
            res.flushBuffer();
        }
        catch (WriterException e) {
            LOGGER.error("Could not generate QR Code", (Throwable)e);
            wr.sendError(500, "Could not generate QR Code");
        }
    }
}

