/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.MembershipCache;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.JSON, OutputType.XML})
@Requires(database=true, parameters={"token"})
@PublicAPI
public final class EditEmail
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditEmail.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new NoCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Member member;
        Database db = req.getDatabase();
        try {
            member = Members.getMember(req);
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load member from DB");
            return;
        }
        if (member == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
            return;
        }
        String previousEmail = member.getEmail();
        String tokenString = req.getParameter((Parameter)StandardParameters.token);
        assert (tokenString != null);
        PersistentToken token = OAuthQuery.getPersistentToken((Database)db, (String)tokenString, (Member)member);
        if (token == null || !token.hasPurpose(PersistentToken.Purpose.change_email) || token.hasExpired()) {
            SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.EMAIL_CHANGE, (String)"Invalid token used to change email of member {} ({})", (Object[])new Object[]{member.getUsername(), member.getId()});
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.TOKEN_INVALID);
            return;
        }
        if (DatabaseQuery.getMemberByEmail((Database)db, (String)token.getData()) != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USER_EXISTS, "Email " + token.getData() + " already used.");
            return;
        }
        member.setEmail(token.getData());
        if (member.getUsername().equals(member.getEmail())) {
            if (DatabaseQuery.getMemberByUsername((Database)db, (String)token.getData()) != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USER_EXISTS, "Email already used as username.");
                return;
            }
            member.setUsername(token.getData());
        }
        token.delete(db);
        try {
            Emails.sendEmailChangeEmail((Database)db, (Member)member, (String)previousEmail, (Group)req.getGroup(), (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
        }
        catch (EmailException ex) {
            LOGGER.error("Failed to send change email notification", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to send change email notification: " + ex.getMessage());
            return;
        }
        SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.EMAIL_CHANGE, (String)"Member {} ({}) changed their email from {} to {}", (Object[])new Object[]{member.getUsername(), member.getId(), previousEmail, member.getEmail()});
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("member-modification");
        out.writeMember(member, true);
        out.endObject();
        out.flush();
        new MembershipCache().remove(member.getId());
    }
}

