/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.member.MemberErrorID;
import java.io.IOException;
import java.util.List;

@Output(types={OutputType.JSON, OutputType.XML})
@Requires(database=true, member=true)
public final class DeleteAdministrator
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        Group group = DatabaseQuery.getAdminGroup((Database)db);
        Member member = req.getMember();
        assert (member != null);
        MemberForGroup mfg = DatabaseQuery.getMemberForGroupByGroupIdMemberId((Database)db, (Long)group.getId(), (Long)member.getId());
        if (mfg == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_NOT_IN_GROUP, "Member is not an administrator.");
            return;
        }
        List mfgs = DatabaseQuery.getMembersForGroupByGroupIdAlphaCol((Database)db, (int)1, (int)-1, (Long)group.getId());
        if (mfgs.size() <= 1) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.AT_LEAST_1_ADMINISTRATOR);
            return;
        }
        mfg.delete(db);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("administrator-delete");
        out.writeMember(member, true);
        out.endObject();
        out.flush();
        new UserDetailsManager().remove(member.getId());
    }
}

