/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mfa.MFA;
import com.pageseeder.base.mfa.core.Challenge;
import com.pageseeder.base.mfa.core.ChallengeRequest;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Authenticator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.Authenticators;
import java.io.IOException;

@Requires(database=true, parameters={"authenticator"})
@Output(types={OutputType.XML, OutputType.JSON})
public class CreateAuthenticatorChallenge
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        return new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        Member member = req.getAuthenticatedMember();
        assert (member != null);
        Database db = req.getDatabase();
        String authId = req.getParameter((Parameter)StandardParameters.authenticator);
        assert (authId != null);
        Authenticator authenticator = Authenticators.getAuthenticator((Database)db, (long)member.getId(), (String)authId);
        if (authenticator == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "No matching authenticator to verify");
            return;
        }
        ChallengeRequest challengeRequest = MFA.createChallenge((Database)db, (Authenticator)authenticator, (Member)member);
        Challenge challenge = challengeRequest.getChallenge();
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("challenge-request");
        out.field("successful", challengeRequest.isSuccessful());
        out.field("status", challengeRequest.getStatus().id());
        out.field("message", challengeRequest.getMessage());
        if (challenge != null) {
            challenge.print((OutputPrinter)out);
        }
        out.endObject();
        out.flush();
    }
}

