/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.mail;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.logback.MailEvent;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.mail.MailLogger;
import com.pageseeder.base.mail.MessageHandler;
import com.pageseeder.base.mail.MessageReceived;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.state.GroupStateManager;
import com.pageseeder.base.util.HTMLSanitizer;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Flags;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.mail.MailHosts;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.Nullable;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.TooMuchDataException;

public class IncomingMailHandler
implements org.subethamail.smtp.MessageHandler {
    public static boolean shutdown = false;
    private static final Pattern EMAIL_TITLE = Pattern.compile("(?:\\[[^]]*])?\\s{0,5}(?:\\((?:Task|Workflow)\\))?\\s{0,5}(.+)");
    private static final Pattern IGNORE_RECIPIENT = Pattern.compile("(pageseeder|error|email_suppressed|no_email|.+--noreply)@[^@]+$");
    private static final Pattern ORIGINAL_RECIPIENT = Pattern.compile("Original-Recipient: rfc822;(.*)");
    private static final Pattern ACTION = Pattern.compile("Action: (.*)");
    private String from = null;
    private final Map<String, MailDestination> recipients = new HashMap<String, MailDestination>();

    public void from(String from) throws RejectException {
        this.from = from;
    }

    public void recipient(String recipient) throws RejectException {
        Transaction tr;
        Database db;
        if (IGNORE_RECIPIENT.matcher(recipient).matches()) {
            MailDestination dest = new MailDestination();
            dest.toIgnore = true;
            this.recipients.put(recipient, dest);
            return;
        }
        try {
            db = Database.open();
            tr = new Transaction(db);
            tr.begin();
        }
        catch (OpenDatabaseException | StartTransactionException ex) {
            MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, Collections.singleton(recipient), null, (String)"Failed to open database", (Throwable)ex));
            throw new RejectException("Please try again later, there was an error opening database: " + ex.getMessage());
        }
        try {
            if (!MailHosts.isValid(recipient, db)) {
                tr.abort();
                MailLogger.bounce((String)this.from, (String)recipient);
                throw new RejectException("Invalid recipient " + recipient);
            }
            MailDestination dest = this.computeDestination(recipient, db, tr);
            if (dest.rejectError != null) {
                tr.abort();
                MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, Collections.singleton(recipient), null, (String)dest.rejectError, null));
                throw new RejectException(dest.rejectError);
            }
            this.recipients.put(recipient, dest);
            tr.commit();
        }
        catch (DatabaseException ex) {
            tr.abort();
            throw new RejectException("Please try again later, there was an error opening database: " + ex.getMessage());
        }
        finally {
            db.close();
        }
    }

    public boolean isBroadcast(String recipient) {
        return recipient != null && !recipient.contains("--silent@");
    }

    public boolean isAnnounce(String recipient) {
        return recipient != null && (recipient.contains("--announce@") || recipient.contains("--announce--preserve@"));
    }

    public boolean isPreserve(String recipient) {
        return recipient != null && (recipient.contains("--preserve@") || recipient.contains("--announce--preserve@"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable String data(InputStream data) throws RejectException, TooMuchDataException, IOException {
        Database db;
        String subject;
        MimeMessage mail;
        if (shutdown) {
            throw new RejectException("Please try again later, PageSeeder is currently shutting down.");
        }
        Properties props = new Properties();
        Session session = Session.getInstance((Properties)props);
        try {
            mail = new MimeMessage(session, data);
            subject = mail.getSubject();
            if (mail.getFrom() != null && mail.getFrom().length > 0) {
                this.from = ((InternetAddress)mail.getFrom()[0]).getAddress();
            }
            if (Strings.isEmpty((String)this.from) && mail.getSender() != null) {
                this.from = ((InternetAddress)mail.getSender()).getAddress();
            }
            boolean valid_recipient = false;
            for (String recipient : this.recipients.keySet()) {
                MailDestination dest = this.recipients.get(recipient);
                if (dest.toIgnore) {
                    String failed_recipients = this.extractFailedRecipients(mail);
                    MailLogger.logWarn((MailEvent)MailEvent.newIncoming((String)this.from, Collections.singleton(recipient), (String)subject, (String)(Strings.isEmpty((String)failed_recipients) ? "Ignored email" : "Unable to deliver to: " + failed_recipients), null));
                    continue;
                }
                Enumeration autoSub = mail.getMatchingHeaderLines(new String[]{"Auto-Submitted"});
                while (autoSub.hasMoreElements()) {
                    if ("no".equalsIgnoreCase((String)autoSub.nextElement()) || dest.toReturn) continue;
                    MailLogger.logWarn((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)mail.getSubject(), (String)"Ignoring auto-submitted email", null));
                    dest.toIgnore = true;
                }
                if (dest.toIgnore) continue;
                valid_recipient = true;
            }
            if (!valid_recipient) {
                return null;
            }
        }
        catch (Exception ex) {
            MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), null, (String)"Failed to build mime message from incoming email", (Throwable)ex));
            throw new IOException("Failed to parse incoming email: " + ex.getMessage(), ex);
        }
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)subject, (String)"Failed to open database", (Throwable)ex));
            throw new RejectException("Please try again later, there was an error opening database: " + ex.getMessage());
        }
        try {
            for (String recipient : this.recipients.keySet()) {
                if (this.recipients.get((Object)recipient).toIgnore) continue;
                this.handleTo(recipient, mail, db);
            }
        }
        finally {
            db.close();
        }
        return null;
    }

    private @Nullable String extractFailedRecipients(MimeMessage message) throws MessagingException, IOException {
        String failed_header = message.getHeader("X-Failed-Recipients", ", ");
        if (!Strings.isEmpty((String)failed_header)) {
            return failed_header;
        }
        StringBuilder failed_recipients = new StringBuilder();
        Object msg_cont = message.getContent();
        if (msg_cont == null || !(msg_cont instanceof MimeMultipart)) {
            return null;
        }
        MimeMultipart multi = (MimeMultipart)msg_cont;
        if (multi.getContentType() == null || !multi.getContentType().startsWith("multipart/report")) {
            return null;
        }
        for (int i = 0; i < multi.getCount(); ++i) {
            String action;
            MimeBodyPart bp = (MimeBodyPart)multi.getBodyPart(i);
            if (!bp.isMimeType("message/delivery-status")) continue;
            String text = ((Stream)new BufferedReader(new InputStreamReader(bp.getInputStream())).lines().parallel()).collect(Collectors.joining("\n"));
            Matcher matcher = ORIGINAL_RECIPIENT.matcher(text);
            String original_recipient = matcher.find() ? matcher.group(1) : null;
            matcher = ACTION.matcher(text);
            String string = action = matcher.find() ? matcher.group(1) : null;
            if (Strings.isEmpty((String)original_recipient) || !"failed".equals(action)) continue;
            if (failed_recipients.length() == 0) {
                failed_recipients = new StringBuilder(original_recipient);
                continue;
            }
            failed_recipients.append(", ").append(original_recipient);
        }
        return failed_recipients.toString();
    }

    public void done() {
    }

    private void handleTo(String recipient, MimeMessage mail, Database db) throws RejectException {
        MailDestination destination = this.recipients.get(recipient);
        Date today = new Date();
        Transaction tr = null;
        try {
            block76: {
                Properties groupProps;
                Group xlGroup;
                URI uri;
                tr = new Transaction(db);
                tr.begin();
                Group group = destination.groupId == null ? null : DatabaseQuery.getGroupById((Database)db, (Long)destination.groupId);
                URI uRI = uri = destination.uriId == null ? null : DatabaseQuery.getURIById((Database)db, (Long)destination.uriId);
                if (destination.toReturn) {
                    String returnedAddress;
                    try {
                        returnedAddress = GroupProperties.get((Database)db, (Group)group).getProperty("mailReturnedAddress");
                    }
                    catch (IOException ex) {
                        returnedAddress = null;
                        MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)mail.getSubject(), (String)("Failed to load group properties for " + (group == null ? "null" : group.getName())), (Throwable)ex));
                    }
                    if (!Strings.isEmpty((String)returnedAddress)) {
                        try {
                            Emails.sendIncomingMail((MimeMessage)mail, (String)returnedAddress, (String)"RETURNED: ", (String)"This email was returned to PageSeeder.");
                        }
                        catch (EmailException ex) {
                            MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)mail.getSubject(), (String)("Failed to send returned email to " + returnedAddress), (Throwable)ex));
                        }
                    } else {
                        MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)mail.getSubject(), (String)("No mailReturnedAddress property for group " + (group == null ? "null" : group.getName())), null));
                    }
                    tr.commit();
                    return;
                }
                XLink reply_to = null;
                XLink threadRoot = null;
                XLink lastone = null;
                String role = "Comment";
                String last_status = null;
                Member last_assignedto = null;
                String last_priority = null;
                Date last_duedate = null;
                boolean strip_footer = false;
                if (destination.reply_to_id != null && (reply_to = DatabaseQuery.getXLinkById((Database)db, (Long)destination.reply_to_id)) != null) {
                    strip_footer = true;
                    if ("Documentation".equals(reply_to.getContentRole()) || "Documentation-Note".equals(reply_to.getContentRole())) {
                        role = "Documentation-Note";
                    } else if ("Workflow".equals(reply_to.getContentRole())) {
                        role = "Workflow";
                    }
                    threadRoot = XLinks.getThreadRoot((XLink)reply_to);
                    if (!"Documentation-Release".equals(reply_to.getContentRole()) && !"Documentation-Version".equals(reply_to.getContentRole()) && (lastone = threadRoot.getThreadEnd()) != null) {
                        last_status = lastone.getStatus();
                        last_assignedto = lastone.getAssignedTo();
                        last_priority = lastone.getPriority();
                        last_duedate = lastone.getDueDate();
                    }
                }
                String title = IncomingMailHandler.stripSubjectPrefix(mail.getSubject());
                Member mem = DatabaseQuery.getMemberByEmail((Database)db, (String)this.from);
                String username = null;
                Long memberid = null;
                if (mem != null && !MemberRule.isMemberDisabled((Member)mem)) {
                    username = mem.getUsername();
                    memberid = mem.getId();
                }
                UserDetailsManager user_manager = new UserDetailsManager();
                UserDetails details = user_manager.get(db, memberid, false);
                if (!MemberRule.isMemberDisabled((Member)mem)) {
                    details = this.checkErrorReport(mail, details);
                }
                ArrayList<Group> grpc = new ArrayList<Group>();
                Member moderator = this.loadGroupsAndModerator(uri, reply_to, db, details, grpc);
                boolean failedPermissions = false;
                if (this.isAnnounce(recipient) || this.isPreserve(recipient) || !this.isBroadcast(recipient)) {
                    for (Group agroup : grpc) {
                        boolean contrib = MemberRule.isContributorForGroup((UserDetails)details, (String)agroup.getName());
                        boolean manager = MemberRule.isManagerForGroup((UserDetails)details, (String)agroup.getName());
                        if (!(this.isPreserve(recipient) && !manager || this.isAnnounce(recipient) && !contrib) && (this.isBroadcast(recipient) || contrib)) continue;
                        failedPermissions = true;
                    }
                }
                if ((xlGroup = group) == null) {
                    xlGroup = grpc.isEmpty() && reply_to != null ? XLinkRule.getMainGroup((Collection)XLinkRule.getGroups((XLink)reply_to)) : XLinkRule.getMainGroup(grpc);
                }
                if (xlGroup == null) {
                    tr.abort();
                    throw new RejectException("Failed to load group for xlink");
                }
                try {
                    groupProps = GroupProperties.get((Database)db, (Group)xlGroup);
                }
                catch (IOException ex) {
                    groupProps = new Properties();
                    MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)title, (String)("Failed to load group properties for group " + xlGroup.getName()), (Throwable)ex));
                }
                if (reply_to != null) {
                    String orig_title = reply_to.getContentTitle();
                    if (Strings.isEmpty((String)orig_title) || Strings.isEmpty((String)orig_title.trim())) {
                        orig_title = "No title";
                    }
                    if (!title.contains(orig_title) && "true".equals(groupProps.getProperty("mailNewThreadByTitle"))) {
                        reply_to = null;
                        destination.reply_to_id = null;
                        destination.fragment = "default";
                    } else {
                        String string = title = lastone != null ? lastone.getContentTitle() : orig_title;
                    }
                }
                if (title == null) {
                    title = "No title";
                }
                title = title.length() > 250 ? title.substring(0, 250) : title;
                boolean[] exceed = this.autoResponderLimitExceeded(today, threadRoot, uri, destination.fragment, db, this.from);
                if (exceed[1]) {
                    tr.abort();
                    return;
                }
                boolean autoResponderLimit = exceed[0];
                XLink xl = XLink.create((Database)db);
                xl.setContentRole(role);
                xl.setModeratorOnly(Boolean.FALSE);
                xl.setContentTitle(title);
                if (mem != null) {
                    xl.setMember(mem);
                } else {
                    String personal = "";
                    if (mail.getFrom() != null && mail.getFrom().length > 0) {
                        personal = ((InternetAddress)mail.getFrom()[0]).getPersonal();
                    }
                    if (Strings.isEmpty((String)personal) && mail.getSender() != null) {
                        personal = ((InternetAddress)mail.getSender()).getPersonal();
                    }
                    xl.setAuthorName(Strings.isEmpty((String)personal) ? "Unknown" : personal);
                    xl.setAuthorEmail(this.from);
                }
                xl.setDate(today);
                xl.setStatus(last_status);
                xl.setPriority(last_priority);
                xl.setAssignedTo(last_assignedto);
                xl.setDueDate(last_duedate);
                if (moderator != null) {
                    xl.setAccepted(Boolean.valueOf(false));
                    xl.setAssignedTo(moderator);
                    xl.setAssignedDate(today);
                } else {
                    xl.setAccepted(Boolean.valueOf(true));
                    if (threadRoot != null) {
                        threadRoot.setThreadEnd(xl);
                    } else {
                        xl.setThreadEnd(xl);
                    }
                }
                XLinkRule.addGroups((Database)db, (XLink)xl, grpc);
                xl = xl.insert(db);
                boolean found_out_of_office = false;
                String out_of_office_str = GlobalSettings.getString((String)"outOfOfficeString", (String)"out of the office,out of office");
                int out_of_office_limit = GlobalSettings.getInt((String)"outOfOfficeLimit", (int)2);
                if (out_of_office_limit != 0 && mem != null) {
                    String[] to_look_for = Strings.split((String)out_of_office_str.toLowerCase(), (char)',');
                    for (int i = 0; !found_out_of_office && i < to_look_for.length; ++i) {
                        found_out_of_office = mail.getSubject().toLowerCase().contains(to_look_for[i].trim());
                    }
                }
                boolean rejected = grpc.isEmpty() || failedPermissions || found_out_of_office;
                MessageReceived received = this.parseMessage(recipient, mail, xl, strip_footer, xlGroup, groupProps, rejected, db);
                if (reply_to != null && ("Documentation-Release".equals(reply_to.getContentRole()) || "Documentation-Version".equals(reply_to.getContentRole()))) {
                    destination.reply_to_id = null;
                    destination.fragment = "default";
                }
                XLinkRule.addXLink((Database)db, (XLink)xl, (URI)uri, (String)destination.fragment, (Long)destination.reply_to_id);
                Iterator iter = received.getAttachmentURIs();
                ChangesManager changes = ChangesManager.getInstance();
                ChangesBatch batch = new ChangesBatch("Attachments to email from " + username);
                changes.startBatch(db, batch);
                while (uri != null && iter.hasNext()) {
                    String path = (String)iter.next();
                    this.ensureParentURIsExist(uri.getScheme(), uri.getHost().getName(), uri.getPort(), path, db, tr, mem, changes);
                    String usertitle = received.getAttachmentUserTitle(path);
                    String extension = path.substring(1 + path.lastIndexOf(46));
                    String type = Medias.getMediaType((String)extension);
                    Address[] auri = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleType((Database)db, (Transaction)tr, (String)uri.getScheme(), (String)uri.getHost().getName(), (Integer)uri.getPort(), (String)path, null, null, (String)usertitle, (String)type, (boolean)true);
                    if (auri != null) {
                        File f = new File(URIRule.getRealPath((String)Settings.getContextPath(), (String)path));
                        if (f.exists()) {
                            auri.setSize(Long.valueOf(f.length()));
                        }
                        Object loctitle = usertitle;
                        if (usertitle == null) {
                            String[] filename = URIRule.getFilename((URI)auri);
                            loctitle = filename[0] + filename[1];
                        }
                        URIRule.addURIHistoryXLink((URI)auri, (Member)mem, (Date)auri.getDateCreated(), (String)"creation", null, (Database)db);
                        LocatorRule.addXLinkToLocator((Database)db, (XLink)xl, (URI)auri, (String)"default", (String)"page-link", (String)"file-attachment", (String)loctitle);
                        tr.commitAndStart();
                        changes.createURI(db, batch, (URI)auri, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)auri.getId()));
                        continue;
                    }
                    MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)title, (String)("Failed to create URI for attachment " + path), null));
                }
                changes.completeBatch(db, batch);
                tr.commitAndStart();
                try {
                    if (uri != null && (grpc.isEmpty() || failedPermissions)) {
                        MailLogger.logWarn((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)title, (String)("Rejected email because of " + (failedPermissions ? "insufficient permissions" : "forbidden group")), null));
                        try {
                            String rejectAddress;
                            Group mgroup = reply_to != null ? XLinkRule.getMainGroup((XLink)reply_to) : URIRule.getGroupForURI((Database)db, (Long)uri.getId());
                            Emails.sendRejectMessage((Database)db, (XLink)xl, (Group)mgroup);
                            Group reject_grp = URIRule.getGroupForURI((Database)db, (Long)uri.getId());
                            if (reject_grp != null && (rejectAddress = GroupProperties.get((Database)db, (Group)reject_grp).getProperty("mailRejectedAddress")) != null && !"".equals(rejectAddress)) {
                                Emails.sendIncomingMail((MimeMessage)mail, (String)rejectAddress, (String)"REJECTED: ", (String)("This email was rejected by PageSeeder (domain " + recipient.replaceAll("^.*@", "") + ") and your email was nominated to receive rejections. Please see the administrator of this PageSeeder server for more information."));
                            }
                        }
                        catch (Exception ex) {
                            MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)title, (String)("Rejected Comment Notification Not Sent for XLinkId " + xl.getId()), (Throwable)ex));
                        }
                        XLinkRule.deleteXLink((Database)db, (Transaction)tr, (XLink)xl, null);
                        break block76;
                    }
                    if (found_out_of_office) {
                        int nb_of_bounced = mem.getBounceReceived() == null ? 1 : mem.getBounceReceived() + 1;
                        mem.setBounceReceived(Integer.valueOf(nb_of_bounced));
                        try {
                            if (nb_of_bounced >= out_of_office_limit) {
                                mem.setSubmitPref(Flags.add((String)mem.getSubmitPref(), (char)'v'));
                                Emails.sendOutOfOffice((Database)db, (Group)xlGroup, (XLink)xl, (boolean)false);
                            } else {
                                Emails.sendOutOfOffice((Database)db, (Group)xlGroup, (XLink)xl, (boolean)true);
                            }
                        }
                        catch (EmailException ex) {
                            MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)title, (String)("Out of Office Warning Not Sent for XLinkId " + xl.getId()), (Throwable)ex));
                        }
                        XLinkRule.deleteXLink((Database)db, (Transaction)tr, (XLink)xl, null);
                        MailLogger.logWarn((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)title, (String)"Rejected email because of Out of office detection", null));
                        break block76;
                    }
                    StringBuilder message = new StringBuilder();
                    if (!received.getScannedFiles().isEmpty()) {
                        message.append("Files scanned for malware: ");
                        for (File f : received.getScannedFiles()) {
                            message.append(f.getName()).append(", ");
                        }
                        message.setLength(message.length() - 2);
                    }
                    MailLogger.logInfo((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)title, (String)message.toString(), null));
                    if (!rejected) {
                        for (Group grp : grpc) {
                            Date modified = new Date();
                            GroupStateManager.singleton().setCommentsModified(grp, modified);
                        }
                        ChangesManager.getInstance().createComment(db, xl, grpc);
                    }
                    if (autoResponderLimit) {
                        Emails.sendAutoResponder((Database)db, (XLink)xl);
                    }
                    if (moderator != null) {
                        Emails.sendAcceptComment((Database)db, (Group)xlGroup, (XLink)xl, null);
                    } else if (this.isBroadcast(recipient)) {
                        if (this.isPreserve(recipient)) {
                            Emails.sendPreservedIncomingMailComment((Database)db, (MessageReceived)received, (XLink)xl);
                        } else {
                            Address[] ccs;
                            HashMap recipients = new HashMap();
                            Address[] tos = mail.getRecipients(Message.RecipientType.TO);
                            if (tos != null) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                for (Address to : tos) {
                                    InternetAddress add = (InternetAddress)to;
                                    if (recipient.equals(add.getAddress())) continue;
                                    map.put(add.getAddress(), add.getPersonal() == null ? "" : add.getPersonal());
                                }
                                recipients.put("to", map);
                            }
                            if ((ccs = mail.getRecipients(Message.RecipientType.CC)) != null) {
                                HashMap<String, String> map = new HashMap<String, String>();
                                for (Address cc : ccs) {
                                    InternetAddress add = (InternetAddress)cc;
                                    if (recipient.equals(add.getAddress())) continue;
                                    map.put(add.getAddress(), add.getPersonal() == null ? "" : add.getPersonal());
                                }
                                recipients.put("cc", map);
                            }
                            Emails.sendNewComment((Database)db, (XLink)xl, recipients, (String)received.getXHTMLMailPart(), (Notify)(this.isAnnounce(recipient) ? Notify.ANNOUNCE : (xl.getAssignedTo() != null ? Notify.MINIMAL : Notify.NORMAL)), (boolean)false, (boolean)false, (Boolean)false);
                        }
                    }
                    if (mem != null) {
                        mem.setBounceReceived(Integer.valueOf(0));
                    }
                }
                catch (EmailException ex) {
                    MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)title, (String)("Notification Not Sent for XLinkId " + xl.getId()), (Throwable)ex));
                    tr.abort();
                }
                catch (Exception ex) {
                    MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)title, (String)("Notification Not Sent for XLinkId " + xl.getId() + ": Foundation Error"), (Throwable)ex));
                    tr.abort();
                }
            }
            tr.commit();
        }
        catch (DatabaseException ex) {
            String subject;
            tr.abort();
            try {
                subject = mail.getSubject();
            }
            catch (MessagingException ex2) {
                subject = null;
            }
            MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)subject, (String)"Failed to process incoming email: database communication failure", (Throwable)ex));
            throw new RejectException("Failed to process incoming email: database communication failure: " + ex.getMessage());
        }
        catch (Throwable ex) {
            String subject;
            if (tr != null) {
                tr.abort();
            }
            try {
                subject = mail.getSubject();
            }
            catch (MessagingException ex2) {
                subject = null;
            }
            MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), (String)subject, (String)"Failed to process incoming email", (Throwable)ex));
            throw new RejectException("Failed to process incoming email: " + ex.getMessage());
        }
    }

    private UserDetails checkErrorReport(MimeMessage mail, UserDetails details) throws MessagingException {
        String subject;
        UserDetails.Builder builder = new UserDetails.Builder(details);
        String errorGroup = GlobalSettings.getString((String)"errorReportGroup", (String)"");
        if (!errorGroup.isEmpty() && (subject = mail.getSubject()) != null && subject.toLowerCase().startsWith("pageseeder error") && details.getFlags(errorGroup) == null) {
            builder.setFlags(errorGroup, "");
            details = builder.build();
        }
        return details;
    }

    private MailDestination computeDestination(String recipient, Database db, Transaction tr) throws DatabaseException {
        int returned;
        MailDestination destination = new MailDestination();
        String user = null;
        if (recipient != null) {
            int at;
            String trimmed = recipient.trim();
            if (trimmed.matches("^\".*?\"$")) {
                trimmed = trimmed.replaceAll("(^\")|(\"$)", "");
            }
            String string = user = (at = trimmed.indexOf(64)) == -1 ? trimmed : trimmed.substring(0, at);
        }
        if (user == null) {
            destination.rejectError = "Failed to load user from empty recipient";
            return destination;
        }
        int dash = user.indexOf(45);
        String xl_role = null;
        Long prefix_num = null;
        Long uri_id = null;
        String group_name = null;
        if (user.endsWith("--announce") || user.endsWith("--preserve")) {
            user = user.substring(0, user.length() - 10);
        }
        if (user.endsWith("--announce") || user.endsWith("--preserve")) {
            user = user.substring(0, user.length() - 10);
        }
        if (user.endsWith("--silent")) {
            user = user.substring(0, user.length() - 8);
        }
        if (dash != -1) {
            xl_role = user.substring(dash + 1);
            try {
                prefix_num = Long.valueOf(user.substring(0, dash));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((returned = user.indexOf("//returned")) != -1) {
            group_name = user.substring(0, returned);
        } else if (prefix_num == null) {
            group_name = user;
        } else {
            if ("reply".equals(xl_role)) {
                try {
                    destination.reply_to_id = Long.valueOf(user.substring(0, dash));
                }
                catch (NumberFormatException ex) {
                    destination.rejectError = "Invalid Reply To XLinkId in address: " + recipient;
                    return destination;
                }
            }
            try {
                uri_id = Long.valueOf(user.substring(0, dash));
            }
            catch (NumberFormatException ex) {
                destination.rejectError = "Invalid URIId in address: " + recipient;
            }
            destination.fragment = xl_role;
        }
        if (group_name != null) {
            Group group = DatabaseQuery.getGroupByName((Database)db, (String)group_name);
            if (group == null) {
                destination.rejectError = "The recipient does not exist: " + group_name;
                return destination;
            }
            destination.groupId = group.getId();
            if (returned != -1) {
                destination.toReturn = true;
                return destination;
            }
            URI uri = URIRule.getURIForGeneralDiscussion((Database)db, (Transaction)tr, (Group)group);
            if (uri == null) {
                destination.rejectError = "The recipient does not exist: " + group_name;
                return destination;
            }
            destination.uriId = uri.getId();
            destination.fragment = "default";
        } else if (uri_id != null) {
            URI uri = DatabaseQuery.getURIById((Database)db, uri_id);
            if (uri == null) {
                destination.rejectError = "The recipient document does not exist: " + uri_id;
            } else {
                destination.uriId = uri.getId();
            }
        } else {
            XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)destination.reply_to_id);
            if (xl == null || !XLinks.isComment((XLink)xl) && !XLinks.isWorkflow((XLink)xl)) {
                destination.rejectError = "The recipient comment does not exist: " + destination.reply_to_id;
            } else {
                URI uri;
                Locator loc = LocatorRule.getLocatorByXLink((Database)db, (XLink)xl);
                URI uRI = uri = loc == null ? null : loc.getURI();
                if (uri == null) {
                    destination.rejectError = "The recipient comment context does not exist: " + destination.reply_to_id;
                } else {
                    destination.uriId = uri.getId();
                }
            }
        }
        return destination;
    }

    public static String stripSubjectPrefix(String title) {
        if (title == null || title.trim().isEmpty()) {
            title = "No title";
        } else {
            title = title.trim();
            while (title.toLowerCase().startsWith("re:") || title.toLowerCase().startsWith("fwd:")) {
                title = title.substring(title.toLowerCase().startsWith("re:") ? 3 : 4).trim();
            }
            Matcher match = EMAIL_TITLE.matcher(title = title.trim());
            if (match.find()) {
                title = match.group(1);
            }
        }
        return title;
    }

    private void ensureParentURIsExist(String scheme, String host, Integer port, String path, Database db, Transaction tr, Member author, ChangesManager changes) throws DatabaseException {
        String parentPath = path.replaceFirst("/[^/]*$", "");
        URI u = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)port, (String)parentPath);
        if (u != null) {
            return;
        }
        GroupURI guri = DatabaseQuery.getGroupURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)port, (String)(parentPath + "/*"));
        if (guri != null) {
            return;
        }
        u = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleType((Database)db, null, (String)scheme, (String)host, (Integer)port, (String)parentPath, null, null, null, (String)"folder", (boolean)true);
        if (u != null) {
            URIRule.addURIHistoryXLink((URI)u, (Member)author, (Date)u.getDateCreated(), (String)"creation", null, (Database)db);
            tr.commitAndStart();
            changes.createURI(db, u, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)u.getId()));
            this.ensureParentURIsExist(scheme, host, port, parentPath, db, tr, author, changes);
        }
    }

    private boolean[] autoResponderLimitExceeded(Date today, XLink threadRoot, URI uri, String fragment, Database db, String from) {
        int auto_minutes = GlobalSettings.getInt((String)"autoResponderMinutes", (int)90);
        int auto_warnings = GlobalSettings.getInt((String)"autoResponderWarnings", (int)5);
        GregorianCalendar check_cal = new GregorianCalendar();
        check_cal.setTime(today);
        ((Calendar)check_cal).add(12, -auto_minutes);
        Date check_date = check_cal.getTime();
        int check_num = 0;
        if (threadRoot != null) {
            Collection xl_col;
            try {
                xl_col = DatabaseQuery.getRepliesByAuthorEmailDateAfter((Database)db, (XLink)threadRoot, (String)from, (Date)check_date);
            }
            catch (QueryFailedException ex) {
                MailLogger.logError((MailEvent)MailEvent.newIncoming((String)this.from, this.recipients.keySet(), null, (String)"Failed to load replies to compute auto responder limit", (Throwable)ex));
                return new boolean[]{false, false};
            }
            check_num = xl_col.size();
            int auto_reply_limit = GlobalSettings.getInt((String)"autoResponderReplyLimit", (int)10);
            return new boolean[]{check_num >= auto_reply_limit, check_num >= auto_reply_limit + auto_warnings};
        }
        Iterator loci = uri.getLocators((Object)Predicates.predicateLocatorFragment((Database)db, (String)fragment));
        while (loci.hasNext()) {
            Locator loc = (Locator)loci.next();
            if (loc.getFragment() == null || !loc.getFragment().equals(fragment)) continue;
            Collection lfx_col = loc.getXLinksForLocatorCol((Object)Predicates.predicateXLinkForLocatorAuthorEmailDateAfter((Database)db, (String)from, (Date)check_date));
            check_num = lfx_col.size();
        }
        int auto_limit = GlobalSettings.getInt((String)"autoResponderLimit", (int)25);
        return new boolean[]{check_num >= auto_limit, check_num >= auto_limit + auto_warnings};
    }

    private @Nullable Member loadGroupsAndModerator(URI uri, XLink replyTo, Database db, UserDetails details, Collection<Group> groups) throws DatabaseException {
        Collection grpc;
        if (replyTo != null) {
            grpc = XLinkRule.getGroups((XLink)replyTo);
            if ((grpc = GroupRule.removeAdminGroup((Collection)grpc)).size() != MemberRule.removeNonCommentGroups((Collection)grpc, (Map)details.flags()).size()) {
                return null;
            }
        } else {
            Group def_group = URIRule.getDefaultGroupForURI((URI)uri);
            if (def_group != null && GroupRule.userHasAccess((Group)def_group, (UserDetails)details)) {
                grpc = new ArrayList<Group>();
                grpc.add(def_group);
            } else {
                grpc = DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId());
            }
            grpc = MemberRule.removeNonCommentGroups(grpc, (Map)details.flags());
        }
        if (grpc.isEmpty()) {
            return null;
        }
        Member moderator = null;
        for (Group grp : grpc) {
            MemberForGroup mod;
            if (MemberRule.isContributorForGroup((UserDetails)details, (String)grp.getName()) && !GroupRule.emailModerationRequired((Group)grp) || (mod = DatabaseQuery.getModeratorByGroupId((Database)db, (Long)grp.getId())) == null) continue;
            moderator = mod.getMember();
        }
        groups.addAll(grpc);
        return moderator;
    }

    private String getHeaders(String recipient, MimeMessage mail) throws MessagingException {
        Enumeration heade = mail.getMatchingHeaderLines(new String[]{"To", "CC"});
        boolean addHeaders = false;
        while (!addHeaders && heade.hasMoreElements()) {
            String em;
            String line = (String)heade.nextElement();
            if (line.startsWith("To:") || line.startsWith("CC:")) {
                line = line.substring(3);
            }
            if ((em = line.indexOf(60) != -1 && line.indexOf(62) != -1 ? line.substring(1 + line.indexOf(60), line.indexOf(62)).trim() : line.trim()).equalsIgnoreCase(recipient)) continue;
            addHeaders = true;
        }
        StringBuilder heads = new StringBuilder();
        if (addHeaders) {
            Enumeration headers = mail.getMatchingHeaderLines(new String[]{"To", "CC"});
            while (headers.hasMoreElements()) {
                String line = (String)headers.nextElement();
                line = line.replace('<', ' ');
                line = line.replace('>', ' ');
                heads.append(line).append("\n");
            }
            heads.append("\n");
        }
        return heads.toString();
    }

    private MessageReceived parseMessage(String recipient, MimeMessage message, XLink xl, boolean isReply, Group group, Properties groupProps, boolean ignoreAttachments, Database db) throws DatabaseException, MessagingException {
        String contentType;
        String content;
        String html;
        MessageReceived received;
        Long ignoreSize;
        Group grp;
        GroupURI guri;
        String attachmentGroupDir = null;
        if (group != null) {
            attachmentGroupDir = group.getName().replace('-', File.separatorChar) + File.separatorChar;
            String subdir = GlobalSettings.getString((String)"attachmentSubDir", (String)"attachments");
            if (!subdir.isEmpty()) {
                attachmentGroupDir = attachmentGroupDir + subdir + File.separatorChar;
            }
            Calendar now = Calendar.getInstance();
            now.setTimeInMillis(System.currentTimeMillis());
            int month = now.get(2) + 1;
            attachmentGroupDir = attachmentGroupDir + now.get(1) + File.separator + (month < 10 ? "0" : "") + month + File.separator;
        }
        String scheme = (guri = GroupURIRule.getDefaultGroupURI((Group)(grp = XLinkRule.getMainGroup((XLink)xl)))) == null ? Settings.getDocumentScheme() : guri.getScheme();
        String host = guri == null ? GlobalSettings.get((String)"webSiteAddress") : guri.getHost().getName();
        String port = String.valueOf(guri == null ? Settings.getDocumentPort() : guri.getPort());
        long maxSize = GlobalSettings.getLong((String)"maxUploadSize", (long)100000000L);
        try {
            ignoreSize = Long.parseLong(groupProps.getProperty("ignoreEmbeddedAttachmentSize", "20000"));
        }
        catch (NumberFormatException ex) {
            ignoreSize = null;
        }
        MessageHandler handler = new MessageHandler(attachmentGroupDir, this.isPreserve(recipient), isReply, ignoreAttachments, ignoreSize, Long.valueOf(maxSize));
        handler.setFooterDetails(!"false".equals(groupProps.getProperty("stripHtmlEmailFooter")), groupProps.getProperty("emailFooterStart"));
        handler.setURIDetails(scheme, host, port == null ? -1 : Integer.parseInt(port), db);
        try {
            received = handler.handleMessage(message, this.getHeaders(recipient, message));
        }
        catch (IOException e) {
            throw new MessagingException("Failed to handle message contents: " + e.getMessage(), (Exception)e);
        }
        received.setPreserve(this.isPreserve(recipient));
        received.setAnnounce(this.isAnnounce(recipient));
        if (received.hasAttachments() && !"Workflow".equals(xl.getContentRole())) {
            xl.setContentRole("File Attachment");
        }
        if (!Strings.isEmpty((String)(html = received.getXHTMLMailPart()))) {
            content = HTMLSanitizer.sanitizeForComments((String)html);
            contentType = "application/xhtml+xml";
        } else {
            Iterator text_contents = received.getTextContents();
            StringBuilder text = new StringBuilder();
            while (text_contents.hasNext()) {
                text.append((String)text_contents.next());
                if (!text_contents.hasNext()) continue;
                text.append("\n\n");
            }
            content = text.toString();
            contentType = "text/plain";
        }
        Content cont = Content.create((Database)db);
        cont.setType(contentType);
        cont.setData(Strings.isEmpty((String)content) ? " " : content);
        xl.addContents(cont);
        if (isReply) {
            Iterator xli = XLinks.getThreadRoot((XLink)xl).getReplies();
            while (xli.hasNext()) {
                Content xl_cont;
                XLink xla = (XLink)xli.next();
                Collection conts = xla.getContentsCol();
                if (conts.size() != 1 || !content.equals((xl_cont = (Content)conts.iterator().next()).getData())) continue;
                throw new MessagingException("Possible mail loop detected on: ");
            }
        }
        return received;
    }

    private static class MailDestination {
        private String rejectError = null;
        private Long reply_to_id = null;
        private Long uriId = null;
        private String fragment = null;
        private Long groupId = null;
        private boolean toReturn = false;
        private boolean toIgnore = false;

        private MailDestination() {
        }
    }
}

