/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.generators;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.load.LoadingZone;
import com.pageseeder.utils.MemberTempFiles;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Requires(group=true, member=true)
public final class GetCreatedURIs
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetCreatedURIs.class);
    private static final String XSLT_FILTER_FILE_NAME = "GetCreatedURIs.xsl";
    private static @Nullable Templates urisFilterTemplates = null;
    private static final int DEFAULT_MAX_NB = 10;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewGroupCheck(req.getGroup()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String uploadid = LoadingZone.getUploadID(req, res);
        if (uploadid != null && uploadid.isEmpty()) {
            return;
        }
        String manifestName = (String)(uploadid != null ? uploadid + "-" : "") + "uploaded-uris.xml";
        File manifest = new File(MemberTempFiles.getTempFolder(req.getMember(), req.getGroup()), manifestName);
        if (manifest == null || !manifest.exists() || !manifest.isFile()) {
            res.setError(GeneratorStatus.NOT_FOUND, "Manifest file not found (" + manifestName + ")");
            return;
        }
        long max = req.getParameter((Parameter)StandardParameters.max, 10L);
        if (max == -1L) {
            try (FileInputStream input = new FileInputStream(manifest);){
                IOUtils.copy((InputStream)input, (Writer)res.getPrinter(), (Charset)StandardCharsets.UTF_8);
            }
        }
        try (FileInputStream fis = new FileInputStream(manifest);){
            Transformer t = GetCreatedURIs.createFilterTemplates().newTransformer();
            t.setParameter("max", String.valueOf(max));
            SAXSource source = new SAXSource(XMLHelpers.safeXMLReader(), new InputSource(fis));
            t.transform(source, new StreamResult(res.getPrinter()));
        }
        catch (SAXException ex) {
            Logger logger = req.getLogger((Object)this);
            logger.error("Failed to create XML reader for XSLT transformation", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create XML reader for XSLT transformation: " + ex.getLocalizedMessage());
        }
        catch (TransformerConfigurationException ex) {
            Logger logger = req.getLogger((Object)this);
            logger.error("Failed to create XSLT transformer", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create XSLT transformer: " + ex.getLocalizedMessage());
        }
        catch (TransformerException ex) {
            Logger logger = req.getLogger((Object)this);
            logger.error("Failed to transform Log file", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to transform manifest file: " + ex.getLocalizedMessage());
        }
        if (!manifest.delete()) {
            LOGGER.warn("Failed to delete member resource {}, it should be deleted when the JVM exits", (Object)manifest.getAbsolutePath());
            manifest.deleteOnExit();
        }
    }

    private static Templates createFilterTemplates() throws IOException {
        if (urisFilterTemplates == null) {
            try {
                urisFilterTemplates = XMLHelpers.safeTransformerFactory().newTemplates(new StreamSource(GetCreatedURIs.class.getResourceAsStream("/" + GetCreatedURIs.class.getPackage().getName().replace('.', '/') + "/GetCreatedURIs.xsl")));
            }
            catch (TransformerConfigurationException e) {
                throw new IOException("Failed to load filter stylesheet: " + e.getMessageAndLocation(), e);
            }
            catch (TransformerFactoryConfigurationError e) {
                throw new IOException("Failed to load filter stylesheet", e);
            }
        }
        return urisFilterTemplates;
    }
}

