/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.label;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.PSMLFiles;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.label.LabelConfig;
import com.pageseeder.base.label.LabelConfigManager;
import com.pageseeder.base.label.LabelType;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.UnforeseenException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.util.HashSet;
import org.xml.sax.SAXException;

@Requires(group=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class GetLabelConfig
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        assert (group != null);
        String uriid = req.getParameter((Parameter)StandardParameters.uri);
        URI uri = null;
        if (uriid == null) {
            uri = req.getURI();
        } else if (!"none".equals(uriid)) {
            try {
                uri = DatabaseQuery.getURIById((Database)req.getDatabase(), (Long)Long.parseLong(uriid));
            }
            catch (DatabaseException ex) {
                req.getLogger((Object)this).debug("Failed to load URI with ID {}: {}", (Object)uriid, (Object)ex.getMessage());
                return new ForbiddenCheck();
            }
        }
        if (uri != null) {
            return new ViewURICheck(group, uri);
        }
        return new ViewGroupCheck(group);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        assert (group != null);
        String template = GroupRule.getTemplate((Group)group);
        String types = req.getParameter((Parameter)StandardParameters.types);
        HashSet<LabelType> labelTypes = null;
        if (types != null) {
            labelTypes = new HashSet<LabelType>();
            for (String t : types.split(",")) {
                try {
                    LabelType lt = LabelType.valueOf((String)t.toUpperCase().replace('-', '_'));
                    labelTypes.add(lt);
                }
                catch (IllegalArgumentException ex) {
                    res.setError(GeneratorStatus.BAD_REQUEST, "Invalid label type " + t);
                    return;
                }
            }
        }
        boolean otherConfigs = "true".equals(req.getParameter((Parameter)StandardParameters.loadconfigs));
        String uriid = req.getParameter((Parameter)StandardParameters.uri);
        boolean noUris = "none".equals(uriid);
        URI uri = null;
        if (uriid == null) {
            uri = req.getURI();
        } else if (!noUris) {
            try {
                uri = DatabaseQuery.getURIById((Database)req.getDatabase(), (Long)Long.parseLong(uriid));
            }
            catch (DatabaseException ex) {
                throw new UnforeseenException((Throwable)ex);
            }
        }
        try {
            String documenttype;
            LabelConfig config = LabelConfigManager.getLabelConfig((String)template);
            if (URIRule.isPSML((URI)uri) && (documenttype = URIRule.getStyleConfig((URI)uri)) != null) {
                try {
                    LabelConfig modified = PSMLFiles.findLabelingConfig((String)template, (String)documenttype, (LabelConfig)config);
                    if (modified != null) {
                        config = modified;
                    }
                }
                catch (FoundationException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load labels from PSML document config: " + ex.getMessage());
                    return;
                }
            }
            UniversalPrinter out = res.getUniversalWriter();
            config.print((OutputPrinter)out, labelTypes);
            out.flush();
            if (!otherConfigs) return;
        }
        catch (SAXException ex) {
            throw new IOException(ex);
        }
    }
}

