/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.host;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Host;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;

@Output(types={OutputType.JSON, OutputType.XML})
public class GetAllHosts
implements Generator,
SingleCheck {
    private static final int MAX_NB_RESULTS = 1000;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        List hosts;
        Logger logger = req.getLogger((Object)this);
        boolean external = req.getParameter((Parameter)StandardParameters.external, false);
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        try {
            hosts = DatabaseQuery.getAllHostsAlpha((Database)req.getDatabase(), (boolean)external, (int)page, (int)pagesize, (boolean)true);
        }
        catch (QueryFailedException ex) {
            logger.error("Failed to load all hosts", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load hosts from DB: " + ex.getMessage());
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("hosts");
        if (hosts.size() > pagesize) {
            out.field("limitreached", true);
        }
        out.startCollection("hosts", OutputPrinter.CollectionOption.JSON_ONLY);
        for (int i = 0; i < hosts.size() && i < pagesize; ++i) {
            out.writeHost((Host)hosts.get(i));
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

