/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.host;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Host;
import com.pageseeder.mail.MailHosts;
import java.io.IOException;

@Requires(parameters={"name"})
@Output(types={OutputType.XML, OutputType.JSON})
public class DeleteHost
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        String hostName = req.getParameter((Parameter)StandardParameters.name);
        assert (hostName != null);
        Host host = DatabaseQuery.getHostByName((Database)db, (String)(hostName = hostName.toLowerCase()));
        if (host == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Host " + hostName + " was not found.");
            return;
        }
        if (DatabaseQuery.isHostReferenced((Database)db, (Host)host)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Host is still being used and cannot be deleted.");
            return;
        }
        host.delete(db);
        MailHosts.clearInternalHosts();
        SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.DELETION, (String)"Host {} was deleted", (Object[])new Object[]{hostName});
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("host-delete");
        out.endObject();
        out.flush();
    }
}

