/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.search.GroupIndexingThread;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.PSRequester;
import com.pageseeder.search.utils.IndexingThreadBase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.pageseeder.flint.indexing.IndexBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RenameGroupThread
extends ProcessThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenameGroupThread.class);
    private final String newGroupName;
    private final RenameType type;
    private final boolean reindex;
    private final boolean allgroups;
    private int total = -1;
    private int current = -1;

    public static RenameGroupThread rename(String username, Group gp, String newname, boolean reindex) {
        return new RenameGroupThread(username, gp, newname, RenameType.RENAME, reindex, true);
    }

    public static RenameGroupThread archive(String username, Group gp, String newname) {
        return new RenameGroupThread(username, gp, newname, RenameType.ARCHIVE, false, true);
    }

    public static RenameGroupThread unarchive(String username, Group gp, boolean reindex, boolean allgroups) {
        return new RenameGroupThread(username, gp, gp.getName().replaceFirst("^archive-", ""), RenameType.UNARCHIVE, reindex, allgroups);
    }

    private RenameGroupThread(String username, Group group, String newname, RenameType t, boolean reindex, boolean allgroups) {
        super(username, "Renaming group " + group.getName() + " to " + newname, group);
        this.newGroupName = newname;
        this.type = t;
        this.reindex = reindex;
        this.allgroups = allgroups;
    }

    /*
     * Exception decompiling
     */
    public void process() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void revert(Map<File, File> moved) {
        for (Map.Entry<File, File> m : moved.entrySet()) {
            File oldone;
            File newone = m.getKey();
            if (newone.renameTo(oldone = m.getValue())) continue;
            LOGGER.error("Failed to move folder {} to {}", (Object)newone.getAbsolutePath(), (Object)oldone.getAbsoluteFile());
            this.updateStatus(ProcessStage.Status.WARNING, "Failed to move a folder back");
        }
    }

    private void reindex(Group group, Database db) throws QueryFailedException {
        String request = (this.type == RenameType.ARCHIVE ? "Archiving" : "Renaming") + " group " + group.getName();
        IndexBatch batch = new IndexBatch(group.getId() + "/" + group.getName() + "/" + request);
        PSRequester requester = new PSRequester(request);
        Collection urlids = DatabaseQuery.getExternalURIsUsedOrCommentsInGroupByType((Database)db, (Long)group.getId(), null);
        IndexMaster master = IndexMaster.getInstance();
        ArrayList<Long> indexids = new ArrayList<Long>();
        for (Long urlid : urlids) {
            URI uri = DatabaseQuery.getURIById((Database)db, (Long)urlid);
            if (uri == null || !URIs.canBeIndexedAsURL((URI)uri)) continue;
            indexids.add(urlid);
        }
        batch.increaseTotal(indexids.size());
        batch.setComputed();
        for (Long id : indexids) {
            master.indexURL(id, false, batch, requester);
        }
        if (this.type == RenameType.ARCHIVE) {
            master.removeIndex(group.getId().longValue());
        } else if (this.reindex) {
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Starting group re-indexing (in another process thread)");
            GroupIndexingThread thread = GroupIndexingThread.newInstance((String)this.getUsername(), (String)("Indexing group after unarchive for " + group.getName()), (Group)group);
            thread.addTypeToindex(IndexingThreadBase.INDEXTYPE.DOCUMENT);
            thread.addTypeToindex(IndexingThreadBase.INDEXTYPE.COMMENT);
            ProcessManager.getInstance().start((ProcessThread)thread);
        }
    }

    public void writeThreadElements(OutputPrinter out) {
        if (this.total > 0) {
            out.startObject("progress");
            out.field("total", (long)this.total);
            out.field("current", (long)this.current);
            out.endObject();
        }
    }

    public static enum RenameType {
        RENAME,
        ARCHIVE,
        UNARCHIVE;

    }
}

