/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.CreateProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.group.GroupErrorID;
import com.pageseeder.group.RenameGroupThread;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(group=true, member=true, parameters={"name"})
@PublicAPI
public final class RenameGroup
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenameGroup.class);

    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new CreateProjectCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        Member member = req.getMember();
        assert (group != null && member != null);
        String newName = req.getParameter((Parameter)StandardParameters.name);
        boolean reindex = req.getParameter((Parameter)StandardParameters.index, true);
        assert (newName != null);
        if (!this.isNewNameValid(newName, group, req.getDatabase(), res)) {
            return;
        }
        RenameGroupThread thread = RenameGroupThread.rename(member.getUsername(), group, newName, reindex);
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("group-renaming");
        thread.print((OutputPrinter)out);
        out.endObject();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }

    private boolean isNewNameValid(String newName, Group current, Database db, GeneratorResponse res) {
        boolean hasParent;
        Group newGroup;
        if (!GroupRule.isValidGroupName((String)newName)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.ILLEGAL_GROUPNAME);
            return false;
        }
        if (newName.length() > 60) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.ILLEGAL_GROUPNAME, "The group name must not be more than 60 characters.");
            return false;
        }
        try {
            newGroup = DatabaseQuery.getGroupByName((Database)db, (String)newName);
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to load group from DB: {}", (Object)ex.getMessage(), (Object)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load group from DB: " + ex.getMessage());
            return false;
        }
        if (newGroup != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.GROUPNAME_EXISTS);
            return false;
        }
        File docFolder = new File(Settings.getDocumentPath(), newName.replace('-', '/'));
        if (docFolder.exists()) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.FOLDER_EXISTS);
            return false;
        }
        boolean bl = hasParent = newName.indexOf(45) != -1;
        if (!GroupRule.isProject((Group)current) && !hasParent) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.GROUP_TO_PROJECT, "Cannot turn a group into a project");
            return false;
        }
        File webapp = new File(Settings.getContextPath());
        if (GroupRule.isProject((Group)current)) {
            Template newKit = new Template(newName);
            File template = TemplateFiles.getTemplateDirectory((Template)newKit, (File)webapp);
            if (template.exists()) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.CONFIG_FOLDER_EXISTS, "Template folder " + newName + " already exists");
                return false;
            }
            File web = TemplateFiles.getWebDirectory((Template)newKit, (File)webapp);
            if (web.exists()) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.CONFIG_FOLDER_EXISTS, "Woconfig folder " + newName + " already exists");
                return false;
            }
        }
        if (hasParent) {
            String name = newName.substring(0, newName.lastIndexOf(45));
            while (true) {
                Group project;
                try {
                    project = DatabaseQuery.getGroupByName((Database)db, (String)name);
                }
                catch (QueryFailedException ex) {
                    LOGGER.error("Failed to load parent project from DB: {}", (Object)ex.getMessage(), (Object)ex);
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load parent project from DB: " + ex.getMessage());
                    return false;
                }
                if (project == null) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.PROJECT_MISSING, "Parent project " + name + " is missing");
                    return false;
                }
                if (!GroupRule.isProject((Group)project)) {
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.PROJECT_MISSING, "Parent project " + name + " is a group");
                    return false;
                }
                if (name.indexOf(45) == -1) break;
                name = name.substring(0, name.lastIndexOf(45));
            }
        }
        return true;
    }
}

