/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

@Requires(database=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class ListProjectsWithTemplate
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck(req.getHttpServletRequest());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        boolean archived = req.getParameter((Parameter)StandardParameters.archived, false);
        ArrayList<Group> projects = new ArrayList<Group>();
        File webapp = new File(Settings.getContextPath());
        File template = new File(webapp, "WEB-INF/config/template");
        Object[] files = template.listFiles();
        if (files != null) {
            Arrays.sort(files);
            FilenameFilter filter = (dir, name) -> !name.startsWith(".");
            for (Object file : files) {
                Group project;
                String[] children;
                String name2 = ((File)file).getName();
                if (name2.startsWith("archive-") != archived || !((File)file).isDirectory() || (children = ((File)file).list(filter)) == null || children.length == 0 || (project = DatabaseQuery.getGroupByName((Database)db, (String)name2)) == null || !GroupRule.isProject((Group)project)) continue;
                projects.add(project);
            }
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("projects");
        out.startCollection("projects", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Group p : projects) {
            out.writeGroup(p, true, false, false);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

