/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ArchiveGroupCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.group.GroupErrorID;
import com.pageseeder.group.RenameGroupThread;
import java.io.IOException;
import org.eclipse.jdt.annotation.Nullable;

@Requires(group=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class ArchiveGroup
implements Generator,
SingleCheck {
    private static final int MAX_GROUP_LENGTH = 55;
    private static final int MAX_RENAME_ATTEMPTS = 10000;

    @ContentPermission(value=ArchiveGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ArchiveGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Group group = req.getGroup();
        Member member = req.getMember();
        assert (group != null && member != null);
        if (GroupRule.isArchived((Group)group)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.GROUP_ARCHIVED, "Group is already archived");
            return;
        }
        String newname = this.findGroupName(group, req.getDatabase());
        if (newname == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Failed to find valid archived name for group " + group.getName());
            return;
        }
        GroupRule.ensureParentProjectsExist((String)newname, (Group)group, (Database)req.getDatabase());
        RenameGroupThread thread = RenameGroupThread.archive(member.getUsername(), group, newname);
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("group-archive");
        thread.print((OutputPrinter)out);
        out.endObject();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }

    private @Nullable String findGroupName(Group group, Database db) throws QueryFailedException {
        String originalName = group.getName();
        if (!originalName.startsWith("archive-")) {
            String groupName = this.validateGroupNameLength("archive-" + originalName);
            Group match = null;
            for (int j = 1; j < 10000 && (match = DatabaseQuery.getGroupByName((Database)db, (String)groupName)) != null; ++j) {
                groupName = this.validateGroupNameLength("archive-" + originalName + "_" + j);
            }
            if (match != null) {
                return null;
            }
            return groupName;
        }
        return originalName;
    }

    private String validateGroupNameLength(String name) {
        if (name.length() > 55) {
            int lastUnderscore = name.lastIndexOf(95);
            if (lastUnderscore == -1) {
                return name.substring(0, 55);
            }
            return name.substring(0, lastUnderscore - (name.length() - 55)) + name.substring(lastUnderscore);
        }
        return name;
    }
}

