/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.filter;

import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.common.properties.GlobalSettings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pageseeder.berlioz.security.ContentSecurityPolicy;
import org.pageseeder.berlioz.security.Directive;
import org.pageseeder.berlioz.security.NonceFactory;

public final class SecurityHeadersFilter
implements Filter {
    private final NonceFactory nonceFactory = new NonceFactory();
    private static final ContentSecurityPolicy DEFAULT_CSP = SecurityHeadersFilter.buildDefaultCSP();
    private static final ContentSecurityPolicy DEFAULT_DEV_CSP = DEFAULT_CSP.builder().set(Directive.CONNECT_SRC, "'self' wss://localhost:9000").build();

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        SecurityLog.setup((HttpServletRequest)req);
        this.setHeaders(req, res);
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    private void setHeaders(HttpServletRequest req, HttpServletResponse res) {
        String cspMode = GlobalSettings.getString((String)"cspMode", (String)"off");
        if ("enforce".equals(cspMode) || "report".equals(cspMode)) {
            String header;
            String cspReportUri = GlobalSettings.getString((String)"cspReportUri", (String)"");
            String cspReportTo = GlobalSettings.getString((String)"cspReportTo", (String)"default");
            String nonce = this.nonceFactory.generate();
            req.setAttribute("berlioz-nonce", (Object)nonce);
            ContentSecurityPolicy csp = SecurityHeadersFilter.getDefaultContentSecurityPolicy(req).withNonce(Directive.SCRIPT_SRC, nonce);
            String string = header = "enforce".equals(cspMode) ? "Content-Security-Policy" : "Content-Security-Policy-Report-Only";
            if (SecurityHeadersFilter.isValidReportURI(cspReportUri) && SecurityHeadersFilter.isValidReportTo(cspReportTo)) {
                csp = csp.withValue(Directive.REPORT_URI, cspReportUri).withValue(Directive.REPORT_TO, cspReportTo);
                res.setHeader("Report-To", "{\"group\":\"" + cspReportTo + "\",\"max_age\":10886400,\"endpoints\":[{\"url\":\"" + cspReportUri + "\"}]}");
                res.setHeader("Reporting-Endpoints", cspReportTo + "=\"" + cspReportUri + "\"");
            }
            res.setHeader(header, csp.toString());
        }
        res.setHeader("Permissions-Policy", "microphone=(),camera=(self),fullscreen=(self),payment=()");
        res.setHeader("Referrer-Policy", "strict-origin-when-cross-origin");
        res.setHeader("X-Frame-Options", "SAMEORIGIN");
        res.setHeader("X-XSS-Protection", "0");
        res.setHeader("X-Content-Type-Options", "nosniff");
    }

    private static ContentSecurityPolicy getDefaultContentSecurityPolicy(HttpServletRequest req) {
        boolean isDev = req.getServerPort() == 9000;
        return isDev ? DEFAULT_DEV_CSP : DEFAULT_CSP;
    }

    private static boolean isValidReportURI(String reportUri) {
        if (!reportUri.startsWith("https://")) {
            return false;
        }
        try {
            new URI(reportUri);
        }
        catch (URISyntaxException ex) {
            return true;
        }
        return true;
    }

    private static boolean isValidReportTo(String reportTo) {
        return reportTo.matches("^[A-Za-z0-9!#$%&'*.^_`|~-]+$");
    }

    private static ContentSecurityPolicy buildDefaultCSP() {
        ContentSecurityPolicy.Builder policy = new ContentSecurityPolicy.Builder();
        policy.set(Directive.DEFAULT_SRC, "'self'");
        policy.set(Directive.FRAME_ANCESTORS, "'self'");
        policy.set(Directive.OBJECT_SRC, "'none'");
        policy.set(Directive.BASE_URI, "'self'");
        policy.set(Directive.FRAME_SRC, "'self' https://www.youtube.com https://player.vimeo.com https://open.spotify.com https://w.soundcloud.com");
        policy.set(Directive.SCRIPT_SRC, "'self' 'unsafe-eval' 'strict-dynamic'");
        policy.set(Directive.STYLE_SRC, "'self' 'unsafe-inline'");
        policy.set(Directive.IMG_SRC, "'self' data: *");
        return policy.build();
    }
}

