/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.display;

import com.pageseeder.base.document.URIException;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.InternalURIFetcher;
import com.pageseeder.base.rule.Thumbnails;
import com.pageseeder.base.rule.URIFetcherStatus;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.util.ImageThumbnail;
import com.pageseeder.base.util.PDFThumbnail;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.common.http.EntityInfo;
import com.pageseeder.common.http.FileEntityInfo;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThumbnailServlet
extends HttpServlet {
    private static final long serialVersionUID = 8209920607941857971L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ThumbnailServlet.class);
    private static final int DEFAULT_SIZE = 400;
    private static final int MAX_AGE = 3600;
    private int size = 400;
    private int threshold = 0;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.size = Integer.parseInt(config.getInitParameter("size"));
        this.threshold = Integer.parseInt(config.getInitParameter("threshold"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        String mediatype;
        boolean thumbnailGenerated;
        File thumbnail;
        boolean archived;
        block70: {
            WebRequest wr = new WebRequest(req, res);
            wr.ensureUtf8Request();
            String uriParameter = wr.getParameter("uri", "");
            if (uriParameter.isEmpty()) {
                wr.sendError(400, "uri is required");
                return;
            }
            boolean force = "true".equals(req.getParameter("force"));
            long uriId = -1L;
            if (Strings.isDigits((String)uriParameter)) {
                try {
                    uriId = Long.parseLong(uriParameter);
                }
                catch (NumberFormatException ex) {
                    wr.sendError(400, "uri parameter must be a number or a valid path");
                    return;
                }
            } else if (!uriParameter.startsWith("/")) {
                wr.sendError(400, "uri parameter must be a number or a valid path");
                return;
            }
            InternalURIFetcher fetcher = null;
            try (Database db = wr.getDatabase();){
                URI uri;
                Transaction tr;
                block68: {
                    if (db == null) {
                        return;
                    }
                    tr = new Transaction(db);
                    tr.begin();
                    if (uriId > 0L) {
                        uri = DatabaseQuery.getURIById((Database)db, (Long)uriId);
                    } else {
                        uri = DatabaseQuery.getURIBySchemePortPath((Database)db, (String)Settings.getDocumentScheme(), (Integer)Settings.getDocumentPort(), (String)RuleUtils.urlEncodeFilepath((String)uriParameter));
                        if (uri != null) {
                            uriId = uri.getId();
                        }
                    }
                    if (uri != null) break block68;
                    wr.sendError(404, "URI could not be found on this web server");
                    tr.abort();
                    return;
                }
                Permissions perm = new Permissions();
                if (!PermissionManager.check((HttpServletRequest)req, (Database)db, (Permissions)perm, (PermissionCheck)new ViewURICheck(uri))) {
                    wr.sendError(403, "Forbidden");
                    tr.abort();
                    return;
                }
                try {
                    if (!URIs.isExternal((URI)uri)) {
                        fetcher = new InternalURIFetcher(uri, req);
                    }
                    archived = URIRule.isArchived((URI)uri);
                    tr.commit();
                }
                catch (StartTransactionException ex) {
                    wr.sendError((Exception)((Object)ex));
                    return;
                }
                catch (URIException | DatabaseException ex) {
                    tr.abort();
                    wr.sendError((Exception)ex);
                    return;
                }
            }
            thumbnail = Thumbnails.notAnImage();
            thumbnailGenerated = false;
            mediatype = "application/octet-stream";
            if (fetcher != null && fetcher.getFile() != null) {
                try {
                    boolean alreadyDone;
                    mediatype = fetcher.getContentType();
                    File original = fetcher.getFile();
                    File maybeThumbnail = Thumbnails.toThumbnailFile((long)uriId, (String)mediatype, (int)this.size, (boolean)false);
                    if (maybeThumbnail == null) {
                        res.sendError(500, "Failed to create thumbnail file");
                        return;
                    }
                    boolean bl = alreadyDone = maybeThumbnail.exists() && maybeThumbnail.lastModified() > fetcher.getLastModified();
                    if (alreadyDone && !force) {
                        if (maybeThumbnail.length() > 0L) {
                            thumbnail = maybeThumbnail;
                            thumbnailGenerated = true;
                        } else {
                            res.setStatus(400);
                        }
                        break block70;
                    }
                    if (fetcher.getStatus() != URIFetcherStatus.SUCCESS) {
                        if (fetcher.getStatus() != URIFetcherStatus.RESPONSE_RETURNED) {
                            LOGGER.warn("URIFetcher Status: {} Message: {}", (Object)fetcher.getStatus(), (Object)fetcher.getStatusMessage());
                            if (fetcher.getStatus() == URIFetcherStatus.NOT_FOUND) {
                                res.sendError(404, fetcher.getStatusMessage());
                            }
                        }
                        return;
                    }
                    if (!Thumbnails.hasThumbnail((String)mediatype)) break block70;
                    try (InputStream ins = fetcher.getContent();){
                        long filesize = original.length();
                        if ("image/svg+xml".equals(mediatype) || "image/webp".equals(mediatype) || ("image/gif".equals(mediatype) || original.getName().endsWith(".apng")) && this.threshold > 0 || mediatype.startsWith("image") && filesize < (long)this.threshold) {
                            thumbnail = original;
                            break block70;
                        }
                        ImageThumbnail producer = mediatype.startsWith("image") ? new ImageThumbnail() : new PDFThumbnail();
                        producer.setHeight(this.size);
                        producer.setWidth(this.size);
                        if (producer instanceof PDFThumbnail) {
                            ((PDFThumbnail)producer).setFilename(original.getName());
                        }
                        try {
                            producer.createThumbnail(ins, maybeThumbnail);
                        }
                        catch (Exception ex) {
                            LOGGER.error("Failed to generate thumbnail for URI {}", (Object)uriId, (Object)ex);
                        }
                        thumbnailGenerated = maybeThumbnail.exists();
                        if (maybeThumbnail.length() == 0L) {
                            res.setStatus(400);
                            return;
                        }
                        thumbnail = maybeThumbnail;
                        Thumbnails.deleteOldThumbnails((long)uriId, (String)mediatype);
                    }
                }
                catch (IOException ex) {
                    wr.sendError((Exception)ex);
                }
                finally {
                    try {
                        fetcher.close();
                    }
                    catch (IOException ex) {
                        LOGGER.error("Unable to close URI fetcher", (Throwable)ex);
                    }
                }
            }
        }
        String mime = thumbnailGenerated ? (thumbnail.getName().endsWith(".png") ? "image/png" : "image/jpeg") : mediatype;
        FileEntityInfo info = new FileEntityInfo(thumbnail, mime);
        res.setContentType(info.getMimeType());
        res.setDateHeader("Last-Modified", info.getLastModified());
        res.setDateHeader("Expires", this.expires());
        res.setHeader("Cache-Control", "max-age=3600, must-revalidate");
        res.setHeader("ETag", info.getETag());
        if (!HttpRequests.checkIfHeaders((HttpServletRequest)req, (HttpServletResponse)res, (EntityInfo)info)) {
            return;
        }
        HttpRequests.setContentLength((HttpServletResponse)res, (long)thumbnail.length());
        this.writeImage(thumbnail, res);
        if (archived) {
            Thumbnails.delete((File)thumbnail);
        }
    }

    private void writeImage(File thumbnail, HttpServletResponse response) {
        try (ServletOutputStream out = response.getOutputStream();){
            Files.copy(thumbnail.toPath(), (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private long expires() {
        return Instant.now().plus(365L, ChronoUnit.DAYS).toEpochMilli();
    }
}

