/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.display;

import com.pageseeder.common.util.MD5;
import com.pageseeder.db.model.Member;
import com.pageseeder.display.WebImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriterImpl;

public class DefaultProfilePicture
implements WebImage,
Serializable {
    private static final long serialVersionUID = -2535106162177972271L;
    private final String initial;
    private final int hue;

    public DefaultProfilePicture(String initial, int hue) {
        this.initial = initial;
        this.hue = hue;
    }

    public static DefaultProfilePicture forName(@Nullable String name) {
        int i;
        Object initial = "A";
        if (name != null && ((String)(initial = (i = name.indexOf(32)) != -1 ? DefaultProfilePicture.toInitial(name.substring(0, i)) + DefaultProfilePicture.toInitial(name.substring(i + 1)) : DefaultProfilePicture.toInitial(name))).isEmpty()) {
            initial = DefaultProfilePicture.toInitial(name.length());
        }
        return new DefaultProfilePicture((String)initial, DefaultProfilePicture.toHue(name));
    }

    public static DefaultProfilePicture forMemberId(long id) {
        char initial = (char)(65 + (int)(id % 26L));
        int hue = DefaultProfilePicture.toHue(id);
        return new DefaultProfilePicture(Character.toString(initial), hue);
    }

    public static DefaultProfilePicture forMember(Member member) {
        Object initial = DefaultProfilePicture.toInitial(member.getFirstName()) + DefaultProfilePicture.toInitial(member.getSurname());
        if (((String)initial).isEmpty()) {
            initial = DefaultProfilePicture.toInitial((member.getFirstName() + member.getSurname()).length());
        }
        return new DefaultProfilePicture((String)initial, DefaultProfilePicture.toHue(member.getId()));
    }

    @Override
    public String getEtag() {
        return "\"" + MD5.hash((String)(this.initial + this.hue)).substring(0, 8) + "\"";
    }

    @Override
    public void write(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String etag = req.getHeader("If-None-Match");
        if (etag != null && etag.equals(this.getEtag())) {
            res.setStatus(304);
            res.setHeader("ETag", this.getEtag());
            res.setHeader("Cache-Control", "no-cache");
            res.setDateHeader("Date", System.currentTimeMillis());
            return;
        }
        this.write(res);
    }

    @Override
    public void write(HttpServletResponse res) throws IOException {
        res.setContentType("image/svg+xml");
        res.setCharacterEncoding("utf-8");
        res.setHeader("ETag", this.getEtag());
        res.setHeader("Cache-Control", "no-cache");
        res.setDateHeader("Date", System.currentTimeMillis());
        DefaultProfilePicture.writeSVGPicture(res.getWriter(), this.initial, this.hue);
    }

    private static void writeSVGPicture(Writer w, String initial, int hue) throws IOException {
        int radius = 80;
        XMLWriterImpl xml = new XMLWriterImpl(w, false);
        xml.openElement("svg");
        xml.attribute("height", 2 * radius + "px");
        xml.attribute("width", 2 * radius + "px");
        xml.attribute("xmlns", "http://www.w3.org/2000/svg");
        xml.attribute("viewBox", "0 0 " + 2 * radius + " " + 2 * radius);
        byte[] font = DefaultProfilePicture.getResourceBytes("/com/pageseeder/display/quicksand-v21-w700.az.woff");
        String base64 = Base64.getEncoder().encodeToString(font);
        xml.openElement("style");
        xml.writeText("@font-face {font-family:'Quicksand';font-style:normal;font-weight:700;src:url(data:text/plain;base64," + base64 + ") format('woff2'); }");
        xml.closeElement();
        xml.openElement("defs");
        xml.openElement("linearGradient");
        xml.attribute("id", "gradient" + hue);
        xml.attribute("gradientTransform", "rotate(90)");
        xml.writeXML("<stop offset=\"10%\" stop-color=\"hsl(" + hue + ", 66%, 55%)\"/>");
        xml.writeXML("<stop offset=\"90%\" stop-color=\"hsl(" + hue + ", 66%, 44%)\"/>");
        xml.closeElement();
        xml.closeElement();
        xml.openElement("circle");
        xml.attribute("r", radius);
        xml.attribute("cy", radius);
        xml.attribute("cx", radius);
        xml.attribute("fill", "url(#gradient" + hue + ")");
        xml.attribute("pointer-events", "none");
        xml.closeElement();
        xml.openElement("text");
        xml.attribute("y", radius * 42 / 32);
        xml.attribute("x", radius);
        xml.attribute("fill", "white");
        xml.attribute("text-anchor", "middle");
        xml.attribute("font-size", (double)radius * 0.9 + "px");
        xml.attribute("font-family", "Quicksand, Helvetica");
        xml.attribute("style", "font-weight: 700; text-transform: uppercase; white-space: pre;");
        xml.writeText(initial);
        xml.closeElement();
        xml.closeElement();
        xml.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getResourceBytes(String filepath) {
        try (InputStream is = DefaultProfilePicture.class.getResourceAsStream(filepath);){
            if (is == null) {
                byte[] byArray2 = new byte[]{};
                return byArray2;
            }
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
        catch (IOException ex) {
            return new byte[0];
        }
    }

    private static String toInitial(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            return Character.toString(Character.toUpperCase(c));
        }
        return "";
    }

    private static String toInitial(long id) {
        return Character.toString((char)(65 + (int)(id % 26L)));
    }

    private static int toHue(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return 0;
        }
        String lastname = name.substring(name.lastIndexOf(32) + 1).toUpperCase();
        int colorIndex = 0;
        int[] w = new int[]{31, 23, 17};
        for (int i = 0; i < 3 && i < lastname.length(); ++i) {
            colorIndex += (lastname.charAt(i) - 65) * w[i];
        }
        return Math.abs(colorIndex % 360);
    }

    private static int toHue(long id) {
        return (int)(id * 37L % 360L);
    }
}

