/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.display;

import com.pageseeder.common.util.MD5;
import com.pageseeder.display.WebImage;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CustomImage
implements WebImage,
Serializable {
    private static final long serialVersionUID = -2364337099199522266L;
    private final byte[] content;
    private final String mediaType;
    private final String etag;
    private final long lastModified;

    public CustomImage(byte[] content, String mediaType, long lastModified) {
        this.content = content;
        this.mediaType = mediaType;
        this.lastModified = lastModified;
        this.etag = "\"" + MD5.hash((byte[])content).substring(0, 8) + "\"";
    }

    @Override
    public String getEtag() {
        return this.etag;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void write(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String requestEtag = req.getHeader("If-None-Match");
        if (requestEtag != null) {
            if (requestEtag.equals(this.etag)) {
                res.setStatus(304);
                this.writeCommonHeaders(res);
                return;
            }
        } else {
            try {
                long since = req.getDateHeader("If-Modified-Since");
                if (since > 0L && since == this.getLastModified()) {
                    res.setStatus(304);
                    this.writeCommonHeaders(res);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.write(res);
    }

    @Override
    public void write(HttpServletResponse res) throws IOException {
        res.setContentType(this.mediaType);
        res.setContentLength(this.content.length);
        res.setDateHeader("Last-Modified", this.getLastModified());
        this.writeCommonHeaders(res);
        ServletOutputStream out = res.getOutputStream();
        out.write(this.content);
        out.flush();
    }

    private void writeCommonHeaders(HttpServletResponse res) {
        res.setDateHeader("Date", System.currentTimeMillis());
        res.setHeader("ETag", this.etag);
        res.setHeader("Cache-Control", "no-cache");
    }
}

