/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.model.Group;
import com.pageseeder.validation.AntScriptValidator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;

public final class ValidatePublishScripts
implements Generator,
SingleCheck {
    private volatile @Nullable File webapp = null;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new DevelopCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        if (this.webapp == null) {
            this.webapp = new File(Settings.getContextPath());
        }
        XMLWriter xml = res.getXMLWriter();
        String template = GroupRule.getTemplate((Group)group);
        String projectRoot = "/WEB-INF/config/template/" + template;
        Template kit = new Template(template);
        File root = new File(this.webapp, TemplateFiles.Zone.TEMPLATE.folder(kit));
        List<File> scripts = this.findScripts(root);
        AntScriptValidator validator = new AntScriptValidator();
        xml.openElement("validation");
        xml.attribute("project", template);
        xml.attribute("base", "/WEB-INF/config/template/" + template);
        for (File config : scripts) {
            String fullpath = config.getAbsolutePath().replace(File.separatorChar, '/');
            int index = fullpath.indexOf(projectRoot);
            xml.openElement("file");
            xml.attribute("name", config.getName());
            xml.attribute("location", index > 0 ? fullpath.substring(index + projectRoot.length()) : fullpath);
            validator.validateScript(config);
            xml.attribute("status", validator.wasValid() ? "valid" : "invalid");
            for (String error : validator.getErrors()) {
                xml.element("message", error);
            }
            xml.closeElement();
        }
        xml.closeElement();
    }

    private List<File> findScripts(File root) {
        File[] all = root.listFiles(f -> f.isDirectory() || "build.xml".equalsIgnoreCase(f.getName()) && AntScriptValidator.PARENT_FOLDERS.contains(f.getParentFile().getName()));
        ArrayList<File> scripts = new ArrayList<File>();
        if (all != null) {
            for (File f2 : all) {
                if (f2.isDirectory()) {
                    scripts.addAll(this.findScripts(f2));
                    continue;
                }
                scripts.add(f2);
            }
        }
        return scripts;
    }
}

