/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.db.model.Group;
import com.pageseeder.psml.PSMLConfigValidator;
import java.io.File;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true)
public final class ValidateConfigs
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        String template = GroupRule.getTemplate((Group)group);
        if (Template.isDefault((String)template)) {
            return new ForbiddenCheck();
        }
        return new ConfigureProjectCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Group group = req.getGroup();
        assert (group != null);
        XMLWriter xml = res.getXMLWriter();
        String template = GroupRule.getTemplate((Group)group);
        if (template != null) {
            TemplateFiles kr = new TemplateFiles(template);
            xml.openElement("validation");
            this.validateAll(kr, xml);
            xml.closeElement();
        } else {
            xml.emptyElement("no-style-owner");
        }
        xml.flush();
    }

    private void validateFolder(File folder, TemplateFiles kr, PSMLConfigValidator validator, XMLWriter xml) throws IOException {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.validateFolder(file, kr, validator, xml);
                    continue;
                }
                if (!validator.validateConfigFile(file)) continue;
                ValidateConfigs.outputValidatedFile(file, kr.getWebApp(), validator, xml);
            }
        }
    }

    private void validateAll(TemplateFiles kr, XMLWriter xml) throws IOException {
        PSMLConfigValidator validator = new PSMLConfigValidator();
        this.validateFolder(kr.get((TemplateZone)TemplateFiles.Zone.TEMPLATE), kr, validator, xml);
    }

    private static void outputValidatedFile(File file, File root, PSMLConfigValidator validator, XMLWriter xml) throws IOException {
        xml.openElement("file");
        xml.attribute("name", file.getName());
        xml.attribute("path", "/" + Files.path((File)root, (File)file));
        xml.attribute("status", validator.wasValid() ? "valid" : "invalid");
        for (String error : validator.getErrors()) {
            xml.element("message", error);
        }
        xml.closeElement();
    }
}

