/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.DevelopCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.psml.PSMLConfigValidator;
import com.pageseeder.validation.AntScriptValidator;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

@Requires(database=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class ValidateAllTemplates
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new DevelopCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        Database db = req.getDatabase();
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("validations");
        out.startCollection("validations", OutputPrinter.CollectionOption.JSON_ONLY);
        File webapp = new File(Settings.getContextPath());
        File templatesContainer = new File(webapp, "WEB-INF/config/template");
        Object[] folders = templatesContainer.listFiles();
        if (folders != null) {
            Arrays.sort(folders);
            FilenameFilter filter = (dir, name) -> !name.startsWith(".");
            for (Object folder : folders) {
                Group project;
                String[] children;
                String template = ((File)folder).getName();
                if (template.startsWith("archive-") || template.contains(".") || !((File)folder).isDirectory() || (children = ((File)folder).list(filter)) == null || children.length == 0 || (project = DatabaseQuery.getGroupByName((Database)db, (String)template)) == null || !GroupRule.isProject((Group)project)) continue;
                Template kit = new Template(template);
                TemplateFiles kr = new TemplateFiles(kit, webapp);
                out.startObject("validation");
                out.field("project", template);
                out.field("base", "/WEB-INF/config/template/" + template);
                this.validateAll(kr, new PSMLConfigValidator(), new AntScriptValidator(), out);
                out.endObject();
            }
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    private void validateAll(TemplateFiles kr, PSMLConfigValidator psml_val, AntScriptValidator ant_val, UniversalPrinter out) throws IOException {
        out.startCollection("files", OutputPrinter.CollectionOption.JSON_ONLY);
        this.validateFolder(kr.get((TemplateZone)TemplateFiles.Zone.TEMPLATE), kr.get((TemplateZone)TemplateFiles.Zone.TEMPLATE), kr, psml_val, ant_val, out);
        out.endCollection();
    }

    private void validateFolder(File base, File folder, TemplateFiles kr, PSMLConfigValidator psml_val, AntScriptValidator ant_val, UniversalPrinter out) throws IOException {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.validateFolder(base, file, kr, psml_val, ant_val, out);
                    continue;
                }
                if (psml_val.validateConfigFile(file)) {
                    ValidateAllTemplates.outputValidatedFile(base, file, psml_val.wasValid() ? "valid" : "invalid", psml_val.getErrors(), out);
                    continue;
                }
                if (!"build.xml".equalsIgnoreCase(file.getName()) || !AntScriptValidator.PARENT_FOLDERS.contains(file.getParentFile().getName())) continue;
                ant_val.validateScript(file);
                ValidateAllTemplates.outputValidatedFile(base, file, ant_val.wasValid() ? "valid" : "invalid", ant_val.getErrors(), out);
            }
        }
    }

    private static void outputValidatedFile(File base, File file, String status, List<String> errors, UniversalPrinter out) throws IOException {
        out.startObject("file");
        out.field("name", file.getName());
        out.field("location", "/" + Files.path((File)base, (File)file));
        out.field("status", status);
        out.startCollection("errors", OutputPrinter.CollectionOption.JSON_ONLY);
        for (String error : errors) {
            out.startObject("error");
            out.field("message", error);
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }
}

