/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.model.Member;
import com.pageseeder.thread.ProcessURLMetadataThread;
import java.io.IOException;

@Requires(database=true, member=true, parameters={"type"})
public final class ProcessURLMetadata
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditAllURLsCheck());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Member member = req.getMember();
        assert (member != null);
        String type = req.getParameter((Parameter)StandardParameters.type);
        boolean overwrite = "true".equals(req.getParameter((Parameter)StandardParameters.overwrite, "false"));
        boolean updatetype = "true".equals(req.getParameter((Parameter)StandardParameters.updatetype, "false"));
        String metadataProperties = req.getParameter((Parameter)StandardParameters.metadata_properties, "");
        assert (type != null);
        ProcessURLMetadataThread thread = new ProcessURLMetadataThread(member.getUsername(), type, updatetype, overwrite);
        thread.addPropertiesToUpdate(metadataProperties.split(","));
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("metadata-process");
        out.write((UniversallyPrintable)thread);
        out.endObject();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }
}

