/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import java.io.FileFilter;
import java.util.Collection;
import org.eclipse.jdt.annotation.Nullable;

final class DevUtils {
    static final FileFilter READABLE_AND_VISIBLE = file -> file.canRead() && !file.isHidden() && file.getName().indexOf(46) != 0;

    private DevUtils() {
    }

    public static boolean allowEditing(Database db, String location, @Nullable Group project) throws QueryFailedException {
        Group p;
        Template template = TemplateFactory.forLocation((String)(location + "/"));
        if (template == null || template.isDefault()) {
            return false;
        }
        return project != null ? project.getName().equals(template.name()) : (p = DatabaseQuery.getGroupByName((Database)db, (String)template.name())) != null && GroupRule.isProject((Group)p);
    }

    public static boolean allowViewing(String location, Collection<Group> projects) {
        Template template = TemplateFactory.forLocation((String)location);
        if (template == null) {
            return false;
        }
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        if (template.isDefault() || template.name().equals(globalTemplate)) {
            return true;
        }
        for (Group p : projects) {
            if (!p.getName().equals(template.name())) continue;
            return true;
        }
        return false;
    }
}

