/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.developer;

import com.pageseeder.base.GroupProperties;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.ConfigureProjectCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.io.Files;
import com.pageseeder.common.io.Template;
import com.pageseeder.common.io.TemplateFactory;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.common.io.TemplateZone;
import com.pageseeder.db.Database;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Group;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true, parameters={"location"})
public final class DeleteProjectFile
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Group group = req.getGroup();
        if (group == null) {
            return new ForbiddenCheck();
        }
        String owner = GroupRule.getTemplate((Group)group);
        Template kit = TemplateFactory.forLocation((String)req.getParameter((Parameter)StandardParameters.location));
        if (kit == null || kit.isDefault() || !kit.name().equals(owner)) {
            return new ForbiddenCheck();
        }
        return new ConfigureProjectCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, QueryFailedException {
        Group group = req.getGroup();
        assert (group != null);
        XMLWriter xml = res.getXMLWriter();
        String owner = GroupRule.getTemplate((Group)group);
        if (owner != null) {
            String location = req.getParameter((Parameter)StandardParameters.location);
            assert (location != null);
            Template template = TemplateFactory.forLocation((String)location);
            TemplateFiles kr = new TemplateFiles(template);
            File f = new File(kr.getWebApp(), location);
            TemplateFiles.Zone zone = TemplateFiles.getZone((Template)template, (String)location);
            boolean isAllowed = zone != null && Files.isDescendantOf((File)kr.get((TemplateZone)zone), (File)f);
            boolean deleted = false;
            xml.openElement("file");
            xml.attribute("name", f.getName());
            xml.attribute("path", location);
            if (template.isDefault() || !isAllowed) {
                xml.attribute("status", "forbidden");
            } else if (f.exists()) {
                if (f.isDirectory()) {
                    xml.attribute("type", "folder");
                    deleted = FileUtils.deleteQuietly((File)f);
                } else {
                    xml.attribute("type", "file");
                    String type = Medias.getMediaType((File)f);
                    if (type != null) {
                        xml.attribute("mediatype", type);
                    }
                    deleted = FileUtils.deleteQuietly((File)f);
                }
                if (deleted) {
                    xml.attribute("status", "deleted");
                    SecurityLog.warn((SecurityLog.EventType)SecurityLog.EventType.CONFIGURATION_CHANGE, (String)"Template file {} was deleted in {}", (Object[])new Object[]{location, template.name()});
                } else {
                    req.getLogger((Object)this).warn("Unable to delete {}", (Object)location);
                    res.setError(GeneratorStatus.SERVER_ERROR, "Unable to delete this file");
                }
            } else {
                xml.attribute("status", "not-found");
                res.setStatus(GeneratorStatus.NOT_FOUND);
            }
            xml.closeElement();
            if (location.endsWith("/config/project.properties")) {
                GroupProperties.clearCache((Database)req.getDatabase(), (String)owner);
            }
        } else {
            xml.emptyElement("no-style-owner");
        }
        xml.flush();
    }
}

