/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.comment.Comments;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.model.Discussion;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Output(types={OutputType.XML, OutputType.JSON})
public final class GetDiscussionsForURI
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 1000L;
    private static final long DEFAULT_DISCUSSION_SIZE = 100L;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        NoCheck check = new NoCheck();
        if (req.getParameter((Parameter)StandardParameters.url) != null) {
            try {
                if (!URIRule.isExternal((URL)RuleUtils.urlEncodeNormalize((String)req.getParameter((Parameter)StandardParameters.url)), (Database)req.getDatabase())) {
                    check = new ViewURICheck(req.getParameter((Parameter)StandardParameters.url));
                }
            }
            catch (MalformedURLException malformedURLException) {}
        } else if (req.getURI() != null && !URIs.isExternal((URI)req.getURI())) {
            check = new ViewURICheck(req.getURI());
        }
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)check);
        }
        return check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        int maxResults = (int)req.getParameter((Parameter)StandardParameters.results, 1000L);
        maxResults = DatabaseQuery.getMaxPageSize((int)maxResults);
        int discussionSize = (int)req.getParameter((Parameter)StandardParameters.discussionsize, 100L);
        String comments = req.getParameter((Parameter)StandardParameters.comments, "all");
        String returngroups = req.getParameter((Parameter)StandardParameters.returngroups, "none");
        String attachedto = req.getParameter((Parameter)StandardParameters.attachedto, "all");
        boolean archived = req.getParameter((Parameter)StandardParameters.archived, false);
        Database db = req.getDatabase();
        Member member = req.getMember();
        URI uri = req.getURI();
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        String url = req.getParameter((Parameter)StandardParameters.url);
        if (url != null) {
            if (uri != null) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.CONTEXT_AMBIGUOUS, "Can not specify both uri and url.");
                return;
            }
            try {
                URL urlObj = RuleUtils.urlEncodeNormalize((String)url);
                uri = URIRule.getURIByURL((Database)db, (URL)urlObj);
                if (uri == null) {
                    res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)CommentErrorID.URL_NOT_FOUND, "No URI found for URL: " + url);
                    return;
                }
                fragment = urlObj.getRef();
            }
            catch (MalformedURLException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.URL_INVALID);
                return;
            }
        } else if (uri == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.URL_NOT_SPECIFIED);
            return;
        }
        if (fragment != null && URIRule.isInvalidFragment((URI)uri, (Group)req.getGroup(), (String)fragment, (Database)req.getDatabase())) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_CASE_MISMATCH, "A fragment with this ID exists with a different case");
            return;
        }
        UserDetails userdetails = member != null ? new UserDetailsManager().get(db, member.getId(), URIRule.isArchivedGroup((URI)uri)) : SecurityUtils.getDefaultUserDetails();
        Collection<Group> grpc = Comments.getReturnGroups(returngroups, req.getGroup(), userdetails, db);
        Collection grps = GroupRule.getGroupNames(grpc);
        if ("none".equals(returngroups)) {
            grpc = null;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.writeURI(uri, false);
        try {
            boolean editAllURLs;
            if (uri.getExternal().booleanValue() && member != null && (editAllURLs = PermissionManager.check((Long)member.getId(), (UserDetails)userdetails, (Database)db, (Permissions)new Permissions(), (PermissionCheck)new EditAllURLsCheck()))) {
                out.startObject("count");
                out.field("discussions-all-groups", (long)DatabaseQuery.getDiscussionCountByURI((Database)db, (URI)uri));
                out.field("attachedtos-all-groups", (long)DatabaseQuery.getAttachedToCountByURI((Database)db, (URI)uri));
                out.endObject();
            }
            boolean includeAttachedto = !"none".equals(attachedto);
            Map locMap = DatabaseQuery.getDiscussionsFragmentsByURIGroups((Database)db, (URI)uri, (Collection)grps, (String)fragment, (boolean)includeAttachedto, (int)maxResults);
            out.startCollection("locators", OutputPrinter.CollectionOption.JSON_ONLY);
            for (Map.Entry entry : locMap.entrySet()) {
                String origfrag;
                List discussions = (List)entry.getValue();
                String curfrag = origfrag = (String)entry.getKey();
                List discDiscussions = null;
                if (curfrag == null) {
                    curfrag = "default";
                }
                if (curfrag.endsWith("//Discussion")) {
                    if (locMap.containsKey(curfrag = curfrag.substring(0, curfrag.length() - 12))) {
                        continue;
                    }
                } else {
                    discDiscussions = (List)locMap.get(curfrag + "//Discussion");
                }
                if (discussions.isEmpty() && (discDiscussions == null || discDiscussions.isEmpty())) continue;
                out.startObject("locator");
                out.field("fragment", curfrag);
                this.outputDiscussions(out, db, discussions, grpc, comments, archived, discussionSize);
                if (discDiscussions != null) {
                    this.outputDiscussions(out, db, discDiscussions, grpc, comments, archived, discussionSize);
                }
                if (includeAttachedto) {
                    this.outputAttachedTo(out, db, discussions, grpc, uri, origfrag, archived);
                    if (discDiscussions != null) {
                        this.outputAttachedTo(out, db, discDiscussions, grpc, uri, origfrag, archived);
                    }
                }
                out.endObject();
            }
            out.endCollection();
        }
        finally {
            out.endObject();
            out.flush();
        }
    }

    private void outputAttachedTo(UniversalPrinter out, Database db, List<Discussion> discussions, Collection<Group> grpc, URI uri, String frag, boolean archived) {
        Locator loc = null;
        out.startCollection("attachedto", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Discussion discussion : discussions) {
            XLink xl;
            if (!discussion.isAttached()) continue;
            if (archived) {
                discussion.loadArchiveComments(db, 1);
            } else {
                discussion.loadRootComment(db);
            }
            if ((xl = discussion.getRootComment()) == null) continue;
            if (loc == null) {
                Iterator loci = uri.getLocators((Object)Predicates.predicateLocatorFragment((Database)db, (String)frag));
                loc = loci.hasNext() ? (Locator)loci.next() : null;
            }
            out.startObject("attachedto");
            out.writeComment(xl, db, loc, grpc, true, true, true, false);
            out.endObject();
        }
        out.endCollection();
    }

    private void outputDiscussions(UniversalPrinter out, Database db, List<Discussion> discussions, Collection<Group> grpc, String comments, boolean archived, int discussionSize) {
        out.startCollection("discussions", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Discussion disc : discussions) {
            if (disc.isAttached()) continue;
            if ("all".equals(comments)) {
                disc.loadAllComments(db, discussionSize);
            } else if ("first".equals(comments)) {
                disc.loadFirstComment(db);
            } else if ("last".equals(comments)) {
                disc.loadLastComment(db, true);
            } else if ("archive".equals(comments)) {
                disc.loadArchiveComments(db, discussionSize);
            } else if ("none".equals(comments)) {
                disc.loadReplyCount(db);
            }
            if (!archived && (disc.getReplyCount() == null || disc.getReplyCount() < 0) && disc.getRootComment() == null && (disc.getReplies() == null || disc.getReplies().isEmpty())) continue;
            out.writeDiscussion(disc, null, grpc);
        }
        out.endCollection();
    }
}

