/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.comment;

import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ArchiveXLinkCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.state.GroupStateManager;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.comment.CommentErrorID;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.db.util.XLinks;
import com.pageseeder.load.LoadingZone;
import com.pageseeder.search.flint.IndexMaster;
import com.pageseeder.search.flint.PSRequester;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;

@Requires(member=true, parameters={"xlink"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class ArchiveComment
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        Database db = req.getDatabase();
        XLink xlink = DatabaseQuery.getXLinkById((Database)db, (Long)req.getParameter((Parameter)StandardParameters.xlink, -1L));
        if (xlink == null) {
            return new NoCheck();
        }
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ArchiveXLinkCheck(URIRule.getURIByXLink((XLink)xlink), xlink));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Object threadRoot;
        Database db = req.getDatabase();
        XLink xl = DatabaseQuery.getXLinkById((Database)db, (Long)req.getParameter((Parameter)StandardParameters.xlink, -1L));
        if (xl == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)CommentErrorID.COMMENT_NOT_FOUND);
            return;
        }
        if (XLinks.isArchived((XLink)xl)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.COMMENT_ARCHIVED);
            return;
        }
        boolean isDraft = XLinks.isDraft((XLink)xl);
        if ((!XLinks.isComment((XLink)xl) || XLinks.isWorkflow((XLink)xl) && !isDraft) && !XLinks.isEditNote((XLink)xl)) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)CommentErrorID.NOT_A_COMMENT);
            return;
        }
        URI uri = URIRule.getURIByXLink((XLink)xl);
        XLinkRule.archiveXLink((XLink)xl);
        xl.setModifiedBy(req.getMember());
        Date modified = new Date();
        xl.setModifiedDate(modified);
        if (XLinks.isComment((XLink)xl) && xl.getAccepted().booleanValue() && !xl.equals(threadRoot = XLinks.getThreadRoot((XLink)xl))) {
            XLinkRule.updateThreadEnd((XLink)threadRoot);
        }
        if (isDraft && xl.getMember() != null) {
            for (Group gp : XLinkRule.getGroups((XLink)xl)) {
                LoadingZone zone = new LoadingZone(gp.getName(), gp.getOwnerDirectory(), xl.getMember().getId(), LoadingZone.buildUploadID(xl.getId()));
                this.deleteFile(zone.baseDirectory());
            }
        }
        if (XLinks.isEditNote((XLink)xl)) {
            uri.setLastModified(new Date());
            XLink edit = XLinks.getThreadRoot((XLink)xl);
            Set groups = uri.getExternal() != false ? DatabaseQuery.getGroupsByURIReverseXRefsComments((Database)db, (Long)uri.getId()) : Collections.singleton(URIRule.getDefaultGroupForURINonNull((URI)uri));
            for (Group g : groups) {
                List versions = URIRule.getReleasesForURI((Database)db, (URI)uri);
                for (XLink version : versions) {
                    if (version.getDate().before(edit.getDate())) continue;
                    new DocumentContentResolver(uri.getId(), g.getName(), g.getId()).clearCacheDocument(version.getId());
                }
            }
            req.getTransaction().commitAndStart();
            ChangesManager.getInstance().modifyURI(db, uri, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId()));
        } else {
            Collection groups = XLinkRule.getGroups((XLink)xl);
            for (Group grp : groups) {
                GroupStateManager.singleton().setCommentsModified(grp, modified);
            }
            req.getTransaction().commitAndStart();
            ChangesManager.getInstance().archiveComment(db, xl, groups);
            if (URIs.canBeIndexedAsURL((URI)uri)) {
                IndexMaster.getInstance().indexURL(uri.getId(), false, null, new PSRequester("Archiving comment " + xl.getId()));
            }
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("comment-archive");
        if (!xl.getAccepted().booleanValue()) {
            out.field("moderated", true);
        }
        out.writeComment(xl);
        out.endObject();
        out.flush();
    }

    private void deleteFile(File file) {
        File[] all;
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isDirectory() && (all = file.listFiles()) != null && all.length > 0) {
            for (File child : all) {
                this.deleteFile(child);
            }
        }
        file.delete();
    }
}

