/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.ai.core;

import com.pageseeder.ai.core.AttachmentManager;
import com.pageseeder.ai.core.Prompts;
import com.pageseeder.ai.core.RedactionEngine;
import com.pageseeder.ai.core.TemplateBuilder;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.publication.NumberedTOC;
import com.pageseeder.base.publication.PublicationManager;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.pageseeder.ai.prompt.PromptTemplate;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AIRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AIRequest.class);
    private final GeneratorRequest req;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private final String promptId;
    private final String publicationId;
    private RedactionEngine redaction = RedactionEngine.NOP;

    public AIRequest(GeneratorRequest req) {
        this.req = req;
        this.promptId = Objects.requireNonNull(req.getParameter((Parameter)StandardParameters.prompt));
        this.publicationId = req.getParameter((Parameter)StandardParameters.publicationid, "");
        req.getParameters().keySet().stream().filter(p -> p.startsWith("parameter.")).forEach(p -> this.parameters.put(p.substring(10), req.getParameter(p, "")));
    }

    public @Nullable PromptTemplate buildTemplate(GeneratorResponse res) {
        Database db = this.req.getDatabase();
        Member member = this.req.getMember();
        Group group = this.req.getGroup();
        URI uri = this.req.getURI();
        assert (uri != null && member != null && group != null);
        PromptTemplate template = Prompts.getPromptTemplate(this.promptId, uri, group);
        if (template == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid prompt ID");
            return null;
        }
        this.redaction = RedactionEngine.getInstance(group);
        TemplateBuilder templateBuilder = new TemplateBuilder(db, group, member, template, this.parameters, this.redaction);
        try {
            List<Long> relatedIds;
            Publication publication = null;
            Map publicationMetadata = null;
            if (!this.publicationId.isEmpty() && (publication = Publications.getPublicationByPublicationIDGroup((Database)db, (String)this.publicationId, (Group)group)) != null) {
                publicationMetadata = Publications.loadPublicationMetadata((Database)db, (Publication)publication, (Group)group, null);
            }
            boolean hasDocumentAttachment = template.listAttachmentRefs().contains("document");
            boolean includeDocument = this.req.getParameter("include-document", false);
            if (hasDocumentAttachment || includeDocument) {
                if (!this.checkAttachment(uri, res)) {
                    return null;
                }
                templateBuilder.addDocument(uri, publication, publicationMetadata);
            }
            if (!(relatedIds = this.getUris(this.req)).isEmpty()) {
                NumberedTOC toc = null;
                if (publication != null) {
                    toc = PublicationManager.singleton().getNumberedTOC(this.req.getDatabase(), publication, true);
                }
                UserDetails userdetails = new UserDetailsManager().get(db, member.getId(), false);
                for (Long uriid : relatedIds) {
                    URI relatedUri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                    if (!this.checkAttachment(relatedUri, res)) {
                        return null;
                    }
                    assert (relatedUri != null);
                    if (!URIRule.userHasAccess((URI)relatedUri, (UserDetails)userdetails, (Database)db)) continue;
                    boolean inPublication = false;
                    if (toc != null && URIRule.isPSML((URI)uri)) {
                        inPublication = toc.getPublicationTree().containsTree(uriid.longValue());
                    }
                    templateBuilder.addRelated(relatedUri, (Publication)(inPublication ? publication : null), inPublication ? publicationMetadata : null);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Unable to attach document to prompt", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "AI not supported");
            return null;
        }
        return template;
    }

    public String getPromptId() {
        return this.promptId;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public RedactionEngine getRedaction() {
        return this.redaction;
    }

    private List<Long> getUris(GeneratorRequest req) {
        String uris = req.getParameter((Parameter)StandardParameters.uris);
        if (uris == null || uris.isEmpty()) {
            return List.of();
        }
        ArrayList<Long> uriids = new ArrayList<Long>();
        for (String uri : Strings.split((String)uris, (char)',')) {
            try {
                uriids.add(Long.parseLong(uri));
            }
            catch (NumberFormatException ex) {
                LOGGER.warn("Unable to parse URI: {}", (Object)uri);
            }
        }
        return uriids;
    }

    private boolean checkAttachment(@Nullable URI uri, GeneratorResponse res) {
        if (uri == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid URI");
            return false;
        }
        boolean isSupported = AttachmentManager.isSupportedType(uri);
        if (!isSupported) {
            res.setError(GeneratorStatus.BAD_REQUEST, "This type of document is not supported");
            return false;
        }
        if (uri.getSize() != null && uri.getSize() > 10000000L) {
            res.setError(GeneratorStatus.BAD_REQUEST, "This document is too large");
            return false;
        }
        return true;
    }
}

