/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.publish.Publisher;
import com.pageseeder.uri.MoveURIThread;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public final class URIMove
implements Action<URI> {
    private @Nullable MoveURIThread thread = null;

    @Override
    public PermissionCheck permissionCheck(URI uri) {
        return new EditURICheck(uri);
    }

    @Override
    public @Nullable Publisher initPublisher(ActionProcessor<URI> parent, Database db, Transaction tr) {
        return null;
    }

    @Override
    public boolean isProcess() {
        return true;
    }

    @Override
    public ProcessThread initThread(ActionProcessor<URI> parent, Database db, Transaction tr) throws ActionException {
        Permissions perm;
        Group group;
        block11: {
            try {
                group = GroupRule.getGroup((Database)db, (String)parent.getGroupName());
            }
            catch (QueryFailedException e) {
                throw new ActionException("Failed to load group " + parent.getGroupName() + ": " + e.getMessage());
            }
            if (group == null) {
                throw new ActionException("Invalid group " + parent.getGroupName());
            }
            perm = new Permissions();
            this.thread = MoveURIThread.newInstance(false, parent.getMemberUsername(), group);
            String guid = parent.getParameter("destination-guriid");
            String uid = parent.getParameter("destination-uriid");
            try {
                if (guid != null) {
                    Long destinationGroupURIID = Long.parseLong(guid);
                    this.thread.setDestinationGroupURIID(destinationGroupURIID);
                    GroupURI guri = DatabaseQuery.getGroupURIById((Database)db, (Long)destinationGroupURIID);
                    if (!PermissionManager.check((Long)parent.getMemberID(), (UserDetails)parent.getUserDetails(), (Database)db, (Permissions)perm, (PermissionCheck)new EditURICheck(guri))) {
                        throw new ActionException("Access denied for destination guri", true);
                    }
                    break block11;
                }
                if (uid != null) {
                    Long destinationURIID = Long.parseLong(uid);
                    this.thread.setDestinationURIID(destinationURIID);
                    URI uri = DatabaseQuery.getURIById((Database)db, (Long)destinationURIID);
                    if (!PermissionManager.check((Long)parent.getMemberID(), (UserDetails)parent.getUserDetails(), (Database)db, (Permissions)perm, (PermissionCheck)new EditURICheck(uri))) {
                        throw new ActionException("Access denied for destination uri", true);
                    }
                    break block11;
                }
                throw new ActionException("Destination not set", true);
            }
            catch (QueryFailedException e) {
                throw new ActionException("Failed to load destination guri " + guid + " or uri " + uid + ": " + e.getMessage());
            }
        }
        String commentGrps = parent.getParameter("comment-groups");
        if (commentGrps != null && !"".equals(commentGrps)) {
            List<String> commentGroups = Arrays.asList(commentGrps.split(","));
            this.thread.setCommentGroups(commentGroups);
            if (!PermissionManager.check((Long)parent.getMemberID(), (UserDetails)parent.getUserDetails(), (Database)db, (Permissions)perm, (PermissionCheck)new EditGroupCheck(group))) {
                throw new ActionException("Access denied for current group edit all comments");
            }
        }
        return this.thread;
    }

    @Override
    public void addObject(URI uri, Database db) throws ActionException {
        if (URIs.isExternal((URI)uri)) {
            throw new ActionException("URLs can not be moved.", true);
        }
        this.thread.addURIToMove(uri.getId(), null);
    }
}

