/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.PSML;
import com.pageseeder.publish.Publisher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;

public final class URIArchiveURL
implements Action<URI> {
    private @Nullable Group group = null;
    private @Nullable ExternalURIArchiver thread = null;

    protected URIArchiveURL() {
    }

    @Override
    public PermissionCheck permissionCheck(URI uri) {
        return new EditAllURLsCheck();
    }

    @Override
    public ProcessThread initThread(ActionProcessor<URI> parent, Database db, Transaction tr) throws ActionException {
        String groupNameOrID = parent.getGroupName();
        try {
            this.group = GroupRule.getGroup((Database)db, (String)groupNameOrID);
        }
        catch (QueryFailedException e) {
            throw new ActionException("Failed to load group " + groupNameOrID + ": " + e.getMessage());
        }
        if (this.group == null) {
            throw new ActionException("Invalid group " + groupNameOrID);
        }
        this.thread = new ExternalURIArchiver(parent.getMemberUsername(), this.group);
        ChangesManager.getInstance().startBatch(db, this.thread.batch);
        return this.thread;
    }

    @Override
    public void addObject(URI uri, Database db) throws ActionException {
        if (!URIs.isExternal((URI)uri)) {
            throw new ActionException("Use archive action for non-URLs.", true);
        }
        this.thread.addURI(uri);
    }

    @Override
    public @Nullable Publisher initPublisher(ActionProcessor<URI> parent, Database db, Transaction tr) {
        return null;
    }

    @Override
    public boolean isProcess() {
        return true;
    }

    static class ExternalURIArchiver
    extends ProcessThread {
        private final ChangesBatch batch;
        private final String username;
        private final List<Long> uriids = new ArrayList<Long>();
        private int currentProgress = 0;

        ExternalURIArchiver(String username, Group group) {
            super(username, "Archiving URLs", group);
            this.username = username;
            this.batch = new ChangesBatch(this.getName());
        }

        private void addURI(URI uri) {
            this.uriids.add(uri.getId());
        }

        public void process() {
            Member author;
            Transaction tr;
            Database db;
            try {
                db = Database.open();
                tr = new Transaction(db);
            }
            catch (OpenDatabaseException ex) {
                this.updateStatus(ProcessStage.Status.FAILED, "Failed to open database");
                return;
            }
            try {
                author = DatabaseQuery.getMemberByUsername((Database)db, (String)this.username);
            }
            catch (QueryFailedException ex) {
                this.updateStatus(ProcessStage.Status.FAILED, "Failed to load author");
                return;
            }
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Archiving " + this.uriids.size() + " URLs");
            for (Long uriid : this.uriids) {
                try {
                    URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                    ++this.currentProgress;
                    uri.setArchived(Boolean.TRUE);
                    Date date = new Date();
                    uri.setDateArchived(date);
                    uri.setLastModified(date);
                    URIRule.addURIHistoryXLink((URI)uri, (Member)author, (Database)db);
                    URIRule.updateLastModifedForXRefs((URI)uri, (Date)new Date(), (Database)db);
                    this.updateStatus(ProcessStage.Status.INPROGRESS, "Archived URL " + uriid);
                    tr.commitAndStart();
                    ChangesManager.getInstance().archiveURI(db, this.batch, uri, Collections.emptyList());
                    PSML.indexXRefSourceTargetURIsWithBatch(db, uri, this.batch);
                }
                catch (DatabaseException ex) {
                    this.updateStatus(ProcessStage.Status.ERROR, "Failed to archive URI " + uriid + ": " + ex.getMessage());
                }
            }
            this.currentProgress = this.uriids.size();
            ChangesManager.getInstance().completeBatch(db, this.batch);
            this.complete("Successfully archived " + this.uriids.size() + " URLs");
        }

        public void writeThreadElements(OutputPrinter out) {
            out.startObject("progress");
            out.field("total", (long)this.uriids.size());
            out.field("current", (long)this.currentProgress);
            out.endObject();
        }
    }
}

