/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.Action;
import com.pageseeder.action.ActionException;
import com.pageseeder.action.ActionProcessor;
import com.pageseeder.base.FoundationException;
import com.pageseeder.base.permission.AddWorkflowCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.publish.Publisher;
import com.pageseeder.thread.CreateWorkflowThread;
import com.pageseeder.uri.URIUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class URIAddWorkflow
implements Action<URI> {
    private static final Logger LOGGER = LoggerFactory.getLogger(URIAddWorkflow.class);
    private static final int MAX_WORKFLOW_NOTIFICATION_PSML = 20;
    private static final Comparator<XLink> XLINK_ID_COMPARATOR = Comparator.comparing(XLink::getId);
    private @Nullable CreateWorkflowThread thread = null;
    private @Nullable List<String> statuses = null;
    private @Nullable Group group = null;
    private @Nullable String status = null;

    @Override
    public PermissionCheck permissionCheck(URI uri) {
        if (this.statuses != null) {
            ArrayList<String> permstatuses = new ArrayList<String>(this.statuses);
            permstatuses.remove("none");
            if (!permstatuses.isEmpty()) {
                return new AddWorkflowCheck(this.group, uri, permstatuses);
            }
        }
        return new AddWorkflowCheck(this.group, uri);
    }

    @Override
    public @Nullable Publisher initPublisher(ActionProcessor<URI> parent, Database db, Transaction tr) {
        return null;
    }

    @Override
    public boolean isProcess() {
        return true;
    }

    @Override
    public void addObject(URI uri, Database db) throws ActionException {
        try {
            String error = this.matchesURI(db, uri);
            if (error != null) {
                throw new ActionException("Invalid document " + uri.getDecodedPath() + ": " + error.toLowerCase());
            }
            this.thread.addURI(uri.getId());
        }
        catch (QueryFailedException ex) {
            LOGGER.error("Failed to check URI", (Throwable)ex);
            throw new ActionException("Failed check URI: " + ex.getMessage(), ex);
        }
    }

    @Override
    public ProcessThread initThread(ActionProcessor<URI> parent, Database db, Transaction tr) throws ActionException {
        Member author;
        String groupNameOrID = parent.getGroupName();
        try {
            this.group = GroupRule.getGroup((Database)db, (String)groupNameOrID);
            if (this.group == null) {
                throw new ActionException("Failed to load group " + groupNameOrID);
            }
        }
        catch (QueryFailedException ex) {
            throw new ActionException("Failed to load group " + groupNameOrID, ex);
        }
        try {
            author = DatabaseQuery.getMemberById((Database)db, (Long)parent.getMemberID());
        }
        catch (QueryFailedException ex) {
            throw new ActionException("Failed to load member: " + ex.getMessage(), ex);
        }
        Notify notify = Notify.SILENT;
        int maxPSML = GlobalSettings.getInt((String)"maxWorkflowNotifications", (int)20);
        if (parent.getTotalIDs() <= maxPSML && ((notify = Notify.fromString((String)parent.getParameter(StandardParameters.notify.getName()))) == Notify.UNKNOWN || notify == Notify.ANNOUNCE && !MemberRule.isContributorForGroup((UserDetails)parent.getUserDetails(), (String)this.group.getName()))) {
            notify = Notify.SILENT;
        }
        this.status = parent.getParameter("status");
        if (this.status != null && this.status.isEmpty()) {
            this.status = null;
        }
        String priority = parent.getParameter("priority");
        String content = parent.getParameter("content");
        String contenttype = parent.getParameter("contenttype");
        if (contenttype == null) {
            contenttype = "text/plain";
        }
        String[] labels = null;
        String labelsStr = parent.getParameter("labels");
        if (!URIUtils.checkStatus(null, this.status)) {
            throw new ActionException("status parameter invalid", true);
        }
        if (!URIUtils.checkPriority(null, priority)) {
            throw new ActionException("priority parameter invalid", true);
        }
        if (!URIUtils.checkLabels(null, labelsStr)) {
            throw new ActionException("labels parameter invalid", true);
        }
        if (labelsStr != null && labelsStr.length() > 0) {
            labels = Strings.split((String)labelsStr, (char)',');
        }
        if (!contenttype.equals("text/plain") && !contenttype.equals("application/xhtml+xml")) {
            throw new ActionException("contenttype parameter allowed values: text/plain, application/xhtml+xml");
        }
        try {
            content = XLinkRule.validateContent((String)contenttype, (String)content);
        }
        catch (FoundationException ex) {
            throw new ActionException(ex.getMessage());
        }
        Long assignTo = URIAddWorkflow.getAssignToParameter(parent);
        Date duedate = URIAddWorkflow.getDueDateParameter(parent);
        String filterStatuses = parent.getParameter("uristatus");
        if (filterStatuses != null) {
            this.statuses = Arrays.asList(filterStatuses.split(","));
        }
        CreateWorkflowThread.Workflow workflow = new CreateWorkflowThread.Workflow(author, new Date(), this.status, duedate, priority, assignTo, this.group, content, contenttype, labels, notify);
        this.thread = new CreateWorkflowThread(parent.getMemberUsername(), this.group, null, workflow);
        return this.thread;
    }

    private @Nullable String matchesURI(@Nullable Database db, @Nullable URI uri) throws QueryFailedException {
        if (this.statuses == null || this.statuses.isEmpty() || uri == null || db == null) {
            return null;
        }
        boolean includeNoStatus = this.statuses.contains("none");
        boolean includeOnlyNoStatus = "none".equals(this.status);
        List allWorkflows = URIRule.getWorkflowsForURI((Database)db, (URI)uri, null);
        if (allWorkflows.isEmpty()) {
            if (includeNoStatus) {
                return null;
            }
            return "Document does not have a status";
        }
        allWorkflows.sort(XLINK_ID_COMPARATOR);
        XLink lastone = (XLink)allWorkflows.get(allWorkflows.size() - 1);
        if (!this.statuses.contains(lastone.getStatus())) {
            return includeOnlyNoStatus ? "Document has a status" : "Document has wrong status or you are not allowed to change it: " + lastone.getStatus();
        }
        return null;
    }

    private static @Nullable Long getAssignToParameter(ActionProcessor<URI> processor) throws ActionException {
        String assignToStr = processor.getParameter("assignedto");
        Long assignTo = null;
        if ("".equals(assignToStr)) {
            assignTo = 0L;
        } else if (assignToStr != null) {
            try {
                assignTo = Long.parseLong(assignToStr);
            }
            catch (NumberFormatException ex) {
                throw new ActionException("Invalid format for 'assignTo', parameter MUST be an integer.", true);
            }
        }
        return assignTo;
    }

    private static @Nullable Date getDueDateParameter(ActionProcessor<URI> processor) throws ActionException {
        String duedateStr = processor.getParameter("due");
        Date duedate = null;
        if ("".equals(duedateStr)) {
            duedate = new Date(0L);
        } else if (duedateStr != null) {
            try {
                duedate = XLinkRule.parseDueDate((String)duedateStr);
            }
            catch (ParseException ex) {
                throw new ActionException("Invalid format for due date, format MUST be yyyy-mm-ddThh:mm:ss[+-]hh:mm.", true);
            }
        }
        return duedate;
    }
}

