/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.action;

import com.pageseeder.action.ActionProcessor;
import com.pageseeder.action.URIActionProcessor;
import com.pageseeder.action.XLinkActionProcessor;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.DBObject;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;

public final class ActionUtils {
    private ActionUtils() {
    }

    public static @Nullable ActionProcessor<? extends DBObject> createProcessor(GeneratorRequest req, GeneratorResponse res) {
        Member member = Objects.requireNonNull(req.getMember());
        Group group = Objects.requireNonNull(req.getGroup());
        String object = req.getParameter((Parameter)StandardParameters.object);
        String action = req.getParameter((Parameter)StandardParameters.action);
        assert (object != null && action != null);
        Long memid = member.getId();
        String groupname = group.getName();
        UserDetails userdetails = new UserDetailsManager().get(req.getDatabase(), memid);
        Database db = req.getDatabase();
        Transaction tr = req.getTransaction();
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry param : req.getParameters().entrySet()) {
            if (!((String)param.getKey()).startsWith("action.")) continue;
            params.put(((String)param.getKey()).substring(7), (String)param.getValue());
        }
        params.put("sessionid", req.getHttpServletRequest().getSession().getId());
        try {
            if ("uri".equals(object)) {
                return new URIActionProcessor(action, params, member, groupname, userdetails, SecurityUtils.getUserToken((HttpServletRequest)req.getHttpServletRequest()), db, tr);
            }
            if ("xlink".equals(object)) {
                return new XLinkActionProcessor(action, params, member, groupname, userdetails, SecurityUtils.getUserToken((HttpServletRequest)req.getHttpServletRequest()), db, tr);
            }
        }
        catch (IllegalArgumentException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid action parameter '" + action + "' for object " + object);
            return null;
        }
        res.setError(GeneratorStatus.BAD_REQUEST, "Invalid object parameter '" + object + "', currently, only 'uri' and 'xlink' are supported.");
        return null;
    }
}

