/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.aws;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.pageseeder.aws.Header;
import net.pageseeder.aws.Headers;

public class LiteAwsResponse {
    private final int statusCode;
    private final byte[] body;
    private final Headers headers;

    LiteAwsResponse(int statusCode, Headers headers, byte[] body) {
        this.statusCode = statusCode;
        this.headers = headers;
        this.body = body;
    }

    public static LiteAwsResponse fromConnection(HttpURLConnection connection) throws IOException {
        int responseCode = connection.getResponseCode();
        Headers headers = LiteAwsResponse.toHeaders(connection);
        byte[] body = LiteAwsResponse.toBody(connection, responseCode);
        return new LiteAwsResponse(responseCode, headers, body);
    }

    public int statusCode() {
        return this.statusCode;
    }

    public boolean isSuccessful() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public String bodyAsString() {
        return new String(this.body, StandardCharsets.UTF_8);
    }

    public byte[] body() {
        return this.body;
    }

    public Headers headers() {
        return this.headers;
    }

    private static Headers toHeaders(HttpURLConnection connection) {
        ArrayList<Header> headerList = new ArrayList<Header>();
        Map<String, List<String>> headerFields = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
            String name = entry.getKey();
            if (name == null) continue;
            for (String value : entry.getValue()) {
                headerList.add(new Header(name, Objects.toString(value, ""), false));
            }
        }
        return Headers.of(headerList.toArray(new Header[0]));
    }

    private static byte[] toBody(HttpURLConnection connection, int responseCode) throws IOException {
        try (InputStream in = responseCode >= 400 ? connection.getErrorStream() : connection.getInputStream();){
            if (in == null) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
    }
}

