/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.aws;

import java.io.FileReader;
import java.util.Objects;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiteAwsConfig {
    public static final String REGION_PROPERTY = "aws.region";
    public static final String ACCOUNT_ID_PROPERTY = "aws.accountId";
    public static final String ACCESS_KEY_ID_PROPERTY = "aws.accessKeyId";
    public static final String SECRET_ACCESS_KEY_PROPERTY = "aws.secretAccessKey";
    private static final String DEFAULT_REGION = "ap-southeast-2";
    private static final String DEFAULT_ACCOUNT_ID = "000000000000";
    private static final Logger LOGGER = LoggerFactory.getLogger(LiteAwsConfig.class);
    private final String region;
    private final String accountId;
    private final String key;
    private final String secret;

    public LiteAwsConfig(String region, String accountId, String key, String secret) {
        this.region = Objects.requireNonNull(region, "region must not be null");
        this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
        this.key = Objects.requireNonNull(key, "key must not be null");
        this.secret = Objects.requireNonNull(secret, "secret must not be null");
    }

    public String region() {
        return this.region;
    }

    public String accountId() {
        return this.accountId;
    }

    public String key() {
        return this.key;
    }

    public String secret() {
        return this.secret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteAwsConfig that = (LiteAwsConfig)o;
        return this.region.equals(that.region) && this.accountId.equals(that.accountId) && this.key.equals(that.key) && this.secret.equals(that.secret);
    }

    public int hashCode() {
        return Objects.hash(this.region, this.accountId, this.key, this.secret);
    }

    static Properties loadLocalProperties() {
        Properties properties = new Properties();
        try (FileReader r = new FileReader("./local.properties");){
            properties.load(r);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to load local.properties", ex);
        }
        return properties;
    }

    public static LiteAwsConfig defaultRegion() {
        return new LiteAwsConfig(DEFAULT_REGION, DEFAULT_ACCOUNT_ID, "", "");
    }

    public static LiteAwsConfig forRegion(String region) {
        return new LiteAwsConfig(region, DEFAULT_ACCOUNT_ID, "", "");
    }

    public LiteAwsConfig withRegion(String region) {
        return new LiteAwsConfig(region, this.accountId, this.key, this.secret);
    }

    public LiteAwsConfig withAccountId(String accountId) {
        LiteAwsConfig.checkAccountId(accountId);
        return new LiteAwsConfig(this.region, accountId, this.key, this.secret);
    }

    public LiteAwsConfig withCredentials(String accessKeyId, String secretAccessKey) {
        return new LiteAwsConfig(this.region, this.accountId, accessKeyId, secretAccessKey);
    }

    public static LiteAwsConfig fromProperties(Properties properties) {
        String[] expectedKeys;
        for (String key : expectedKeys = new String[]{REGION_PROPERTY, ACCESS_KEY_ID_PROPERTY, SECRET_ACCESS_KEY_PROPERTY, ACCOUNT_ID_PROPERTY}) {
            if (properties.getProperty(key) != null) continue;
            LOGGER.warn("Missing {} properties", (Object)key);
        }
        LiteAwsConfig.checkAccountId(properties.getProperty(ACCOUNT_ID_PROPERTY, ""));
        return new LiteAwsConfig(properties.getProperty(REGION_PROPERTY, DEFAULT_REGION), properties.getProperty(ACCOUNT_ID_PROPERTY, DEFAULT_ACCOUNT_ID), properties.getProperty(ACCESS_KEY_ID_PROPERTY, ""), properties.getProperty(SECRET_ACCESS_KEY_PROPERTY, ""));
    }

    public static LiteAwsConfig fromLocalProperties() {
        Properties properties = LiteAwsConfig.loadLocalProperties();
        return LiteAwsConfig.fromProperties(properties);
    }

    private static void checkAccountId(String accountId) {
        if (!accountId.matches("^\\d{12}$")) {
            LOGGER.warn("Account ID must be 12 digits long");
        }
    }
}

