/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.aws;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import net.pageseeder.aws.Header;
import org.eclipse.jdt.annotation.Nullable;

public final class Headers
extends AbstractCollection<Header>
implements Iterable<Header> {
    public static final String ACCEPT = "Accept";
    public static final String AUTHORIZATION = "Authorization";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String HOST = "Host";
    public static final String X_AMZ_CONTENT_SHA256 = "x-amz-content-sha256";
    public static final String X_AMZ_DATE = "x-amz-date";
    private static final Headers EMPTY = new Headers(new Header[0]);
    private final Header[] headerList;

    private Headers(Header[] headers) {
        this.headerList = headers;
    }

    public static Headers of(Header ... headers) {
        return new Headers(headers);
    }

    public static Headers fromMap(Map<String, ?> headers) {
        Header[] h = new Header[headers.size()];
        int i = 0;
        for (Map.Entry<String, ?> entry : headers.entrySet()) {
            h[i++] = new Header(entry.getKey(), Objects.toString(entry.getValue()));
        }
        return new Headers(h);
    }

    public static Headers empty() {
        return EMPTY;
    }

    public @Nullable String getValue(String name) {
        Header p = this.get(name);
        return p != null ? p.value() : null;
    }

    public @Nullable Header get(String name) {
        for (Header h : this.headerList) {
            if (!h.name().equalsIgnoreCase(name)) continue;
            return h;
        }
        return null;
    }

    public Headers put(Header header) {
        Header[] copy;
        int found = -1;
        for (int i = 0; i < this.headerList.length; ++i) {
            if (!this.headerList[i].name().equalsIgnoreCase(header.name())) continue;
            found = i;
        }
        if (found >= 0) {
            copy = Arrays.copyOf(this.headerList, this.headerList.length);
            copy[found] = header;
        } else {
            copy = Arrays.copyOf(this.headerList, this.headerList.length + 1);
            copy[copy.length - 1] = header;
        }
        return new Headers(copy);
    }

    public Headers put(String name, String value) {
        return this.put(new Header(name, value));
    }

    public Headers remove(String name) {
        return new Headers((Header[])Arrays.stream(this.headerList).filter(header -> !header.name().equalsIgnoreCase(name)).toArray(Header[]::new));
    }

    public Headers signed() {
        return new Headers((Header[])Arrays.stream(this.headerList).filter(Header::isSigned).toArray(Header[]::new));
    }

    public List<String> lcNames() {
        return Arrays.stream(this.headerList).map(Header::lcName).collect(Collectors.toList());
    }

    public Headers sortByName() {
        Header[] copy = Arrays.copyOf(this.headerList, this.headerList.length);
        Arrays.sort(copy, Comparator.comparing(Header::lcName));
        return new Headers(copy);
    }

    public String toCanonical() {
        StringBuilder canonical = new StringBuilder();
        for (Header p : this.headerList) {
            canonical.append(p.toCanonical()).append('\n');
        }
        return canonical.toString();
    }

    @Override
    public Iterator<Header> iterator() {
        return new Iterator<Header>(){
            private int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.currentIndex < Headers.this.headerList.length;
            }

            @Override
            public Header next() {
                if (this.currentIndex >= Headers.this.headerList.length) {
                    throw new NoSuchElementException();
                }
                return Headers.this.headerList[this.currentIndex++];
            }
        };
    }

    @Override
    public int size() {
        return this.headerList.length;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Header p : this.headerList) {
            s.append(p.toString()).append('\n');
        }
        return s.toString();
    }
}

