/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publisher.core;

import com.pageseeder.common.util.Base64;
import com.pageseeder.publisher.core.PublishThread;
import com.pageseeder.publisher.core.PublishThreadList;
import com.pageseeder.publisher.exceptions.AlreadyRunningException;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.BerliozException;
import org.pageseeder.berlioz.xml.XMLUtils;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PublishManager {
    private static final PublishManager INSTANCE = new PublishManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishManager.class);
    private static final int THREAD_PRIORITY = Math.round(4.0f);
    private static final PublishThreadList THREAD_LIST = new PublishThreadList();
    private final ExecutorService threadPool = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r, "Publishing Thread with priority of " + THREAD_PRIORITY);
        t.setPriority(THREAD_PRIORITY);
        return t;
    });

    private PublishManager() {
    }

    public static PublishManager getInstance() {
        return INSTANCE;
    }

    public void publish(String id, @Nullable File script, String target, String level, boolean download, Map<String, String> properties) throws AlreadyRunningException {
        if (script == null || !script.exists() || !script.isFile()) {
            throw new IllegalArgumentException("Invalid publish script");
        }
        String key = PublishManager.buildPublishKey(properties);
        if (THREAD_LIST.hasKey(key)) {
            PublishThread thread = THREAD_LIST.getWithKey(key);
            if (thread.isFinished()) {
                THREAD_LIST.removeWithKey(key);
            } else {
                String sb = thread.getMessages(true);
                MessagesParser handler = new MessagesParser();
                try {
                    XMLUtils.parse((ContentHandler)handler, (Reader)new StringReader(sb), (boolean)false);
                }
                catch (BerliozException ex) {
                    LOGGER.error("Failed to parse publish job messages: {}", (Object)ex.getMessage(), (Object)ex);
                    throw new AlreadyRunningException(null, null, null);
                }
                throw new AlreadyRunningException(handler.jobid, handler.status, handler.lastMessage);
            }
        }
        PublishThread publishThread = new PublishThread(id, script, target, properties);
        publishThread.setLogLevel(level);
        publishThread.setDownloadWorking(download);
        this.threadPool.execute(publishThread);
        THREAD_LIST.add(id, key, publishThread, this.getWorkingFolderRoot(properties));
    }

    private @Nullable String getWorkingFolderRoot(Map<String, String> properties) {
        String root = properties.get("ps-working");
        return root == null ? null : root.replace("((/|\\\\)ps-(upload|folder|uri|group))(/|\\\\).*?$", "$1");
    }

    public boolean isWorkingFolderInUse(File folder) {
        return THREAD_LIST.hasWorkingFolder(folder.getAbsolutePath());
    }

    public void cancel(String processID) {
        PublishThread thread = THREAD_LIST.getWithID(processID);
        if (thread != null) {
            thread.cancel();
        }
    }

    public void cancel(Map<String, String> properties) {
        PublishThread thread = THREAD_LIST.getWithKey(PublishManager.buildPublishKey(properties));
        if (thread != null) {
            thread.cancel();
        }
    }

    public Map<String, StringBuffer> peek(@Nullable Collection<String> processIDs) {
        HashMap<String, StringBuffer> messageByThreadId = new HashMap<String, StringBuffer>();
        for (String id : processIDs == null || processIDs.isEmpty() ? THREAD_LIST.getIDs() : processIDs) {
            PublishThread thread = THREAD_LIST.getWithID(id);
            StringBuffer sb = thread == null ? PublishManager.notRunning(id) : new StringBuffer(thread.getMessages(true));
            messageByThreadId.put(id, sb);
        }
        return messageByThreadId;
    }

    public StringBuffer getProgressMessage(String processID, boolean removeIfCompleted) {
        PublishThread thread = THREAD_LIST.getWithID(processID);
        if (thread == null) {
            return PublishManager.notRunning(processID);
        }
        String msg = thread.getMessages(false);
        if (removeIfCompleted && thread.isFinished()) {
            THREAD_LIST.removeWithID(processID);
        }
        return new StringBuffer(msg);
    }

    public StringBuffer getProgressMessage(Map<String, String> props, boolean removeIfCompleted) {
        String key = PublishManager.buildPublishKey(props);
        PublishThread thread = THREAD_LIST.getWithKey(key);
        if (thread == null) {
            return PublishManager.notRunning("");
        }
        if (removeIfCompleted && thread.isFinished()) {
            THREAD_LIST.removeWithKey(key);
        }
        return new StringBuffer(thread.getMessages(false));
    }

    private static StringBuffer notRunning(String processID) {
        XMLStringWriter xml = new XMLStringWriter(XML.NamespaceAware.No);
        xml.openElement("publish", true);
        xml.attribute("id", processID == null ? "" : processID);
        xml.element("title", "Publishing Action Not Running");
        xml.element("status", "error");
        xml.openElement("message");
        xml.attribute("type", "error");
        xml.writeText("This publishing action is not currently running, this may be because the same object has been published again.");
        xml.closeElement();
        xml.closeElement();
        return new StringBuffer(xml.toString());
    }

    private static String buildPublishKey(Map<String, String> properties) {
        String uriPath = properties.get("ps-uriPath");
        if (uriPath != null) {
            return properties.get("ps-uriScheme") + "://" + properties.get("ps-uriHost") + ":" + properties.get("ps-uriPort") + uriPath;
        }
        String uploadPath = properties.get("ps-uploadPath");
        if (uploadPath != null) {
            return properties.get("ps-host") + ":" + properties.get("ps-port") + "/" + properties.get("ps-groupName") + "/.upload/" + properties.get("ps-username") + uriPath;
        }
        return "http://" + properties.get("ps-host") + ":" + properties.get("ps-port") + properties.get("ps-groupFolder");
    }

    public static @Nullable String createSessionFolder(@Nullable String jsessionid) {
        if (jsessionid == null) {
            return null;
        }
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            sha.update(jsessionid.getBytes(StandardCharsets.UTF_8));
            String hash = new String(Base64.encode((byte[])sha.digest()));
            StringBuilder toreturn = new StringBuilder();
            String notAllowedInFolder = "/\\?%*:|<>$+=";
            int space = 32;
            int del = 127;
            for (int i = 0; i < hash.length(); ++i) {
                char c = hash.charAt(i);
                if ("/\\?%*:|<>$+=".indexOf(c) != -1 || c <= ' ' || c >= '\u007f') continue;
                toreturn.append(c);
            }
            return toreturn.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Failed to create session folder", ex);
        }
    }

    private static final class MessagesParser
    extends DefaultHandler {
        private @Nullable String jobid = null;
        private @Nullable String status = null;
        private @Nullable String lastMessage = null;
        private @Nullable StringBuilder text = null;

        private MessagesParser() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("status".equals(localName) || "message".equals(localName)) {
                this.text = new StringBuilder();
            } else if ("publish".equals(localName)) {
                this.jobid = attributes.getValue("id");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.text != null) {
                this.text.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("status".equals(localName) && this.text != null) {
                this.status = this.text.toString();
            } else if ("message".equals(localName) && this.text != null) {
                this.lastMessage = this.text.toString();
            }
            this.text = null;
        }
    }
}

