/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.flint.indexing;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import org.pageseeder.flint.Index;
import org.pageseeder.flint.IndexException;
import org.pageseeder.flint.IndexIO;
import org.pageseeder.flint.IndexManager;
import org.pageseeder.flint.OpenIndexManager;
import org.pageseeder.flint.content.Content;
import org.pageseeder.flint.content.ContentTranslator;
import org.pageseeder.flint.indexing.FlintDocument;
import org.pageseeder.flint.indexing.FlintField;
import org.pageseeder.flint.indexing.IndexJob;
import org.pageseeder.flint.indexing.IndexJobQueue;
import org.pageseeder.flint.indexing.IndexListener;
import org.pageseeder.flint.ixml.IndexParser;
import org.pageseeder.flint.ixml.IndexParserFactory;
import org.pageseeder.flint.templates.FlintErrorListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IndexingThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexingThread.class);
    private final IndexListener _listener;
    private final IndexJobQueue _indexQueue;
    private final IndexManager _manager;
    private final boolean _singleThread;
    public static boolean CLOSING_DOWN = false;

    public IndexingThread(IndexManager manager, IndexListener listener, IndexJobQueue queue, boolean singleThread) {
        this._manager = manager;
        this._listener = listener;
        this._indexQueue = queue;
        this._singleThread = singleThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        job = null;
        try {
            try {
                job = this._singleThread != false ? this._indexQueue.nextSingleThreadJob() : this._indexQueue.nextMultiThreadJob();
            }
            catch (InterruptedException ex) {
                if (!IndexingThread.CLOSING_DOWN) {
                    this._listener.error(null, "Interrupted indexing: " + ex.getMessage(), ex);
                }
                Thread.currentThread().interrupt();
                return;
            }
            if (job == null) {
                this._listener.error(null, "Found a null job in indexing queue.", null);
                return;
            }
            if (!this._singleThread && job.isForSingleThread()) {
                this._manager.indexSingleThread(job);
                return;
            }
            if (job.isBatch() && !job.getBatch().isStarted()) {
                job.getBatch().startIndexing();
                this._listener.startBatch(job.getBatch());
            }
            this._listener.startJob(job);
            success = false;
            io = job.getIndex().getIndexIO();
            try {
                if (job.isClearJob()) {
                    if (!Thread.currentThread().isInterrupted()) {
                        try {
                            success = io.clearIndex();
                        }
                        catch (Exception ex) {
                            this._listener.error(job, "Failed to clear index", ex);
                        }
                    }
                } else {
                    success = this.indexContent(job, io);
                }
                job.setSuccess(success);
                job.finish();
                batch = job.getBatch();
                v0 = batchFinished = batch != null && batch.increaseCurrent() != false;
            }
            catch (Exception ex) {
                try {
                    this._listener.error(job, "Unknown error: " + ex.getMessage(), ex);
                    job.finish();
                    batch = job.getBatch();
                    v1 = batchFinished = batch != null && batch.increaseCurrent() != false;
                }
                catch (Throwable var6_12) {
                    job.finish();
                    batch = job.getBatch();
                    v2 = batchFinished = batch != null && batch.increaseCurrent() != false;
                    if (io != null) {
                        if (batchFinished) {
                            io.maybeRefresh();
                        } else if (batch == null && success) {
                            io.maybeRefresh();
                        }
                        if (!this._indexQueue.hasJobsForIndex(job.getIndex())) {
                            io.maybeCommit();
                        }
                    }
                    this._listener.endJob(job);
                    if (batchFinished) {
                        this._listener.endBatch(job.getBatch());
                    }
                    throw var6_12;
                }
                if (io != null) {
                    if (batchFinished) {
                        io.maybeRefresh();
                    } else if (batch == null && success) {
                        io.maybeRefresh();
                    }
                    if (!this._indexQueue.hasJobsForIndex(job.getIndex())) {
                        io.maybeCommit();
                    }
                }
                this._listener.endJob(job);
                if (batchFinished) {
                    this._listener.endBatch(job.getBatch());
                } else {
                    ** GOTO lbl83
                }
            }
            if (io != null) {
                if (batchFinished) {
                    io.maybeRefresh();
                } else if (batch == null && success) {
                    io.maybeRefresh();
                }
                if (!this._indexQueue.hasJobsForIndex(job.getIndex())) {
                    io.maybeCommit();
                }
            }
            this._listener.endJob(job);
            if (batchFinished) {
                this._listener.endBatch(job.getBatch());
            }
            OpenIndexManager.closeOldReaders();
        }
        catch (Exception ex) {
            this._listener.error(job, "Unexpected general error: " + ex.getMessage(), ex);
        }
    }

    private boolean indexContent(IndexJob job, IndexIO io) {
        boolean deleted;
        Content content = this._manager.getContent(job);
        if (content == null) {
            this._listener.error(job, "Failed to retrieve Source content", null);
            return false;
        }
        try {
            deleted = content.isDeleted();
        }
        catch (IndexException ex) {
            this._listener.error(job, ex.getMessage(), ex);
            return false;
        }
        if (deleted) {
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            try {
                io.deleteDocuments(content.getDeleteRule());
            }
            catch (Exception ex) {
                this._listener.error(job, "Failed to delete Lucene Documents from Index", ex);
                return false;
            }
            return true;
        }
        IndexParser parser = IndexParserFactory.getInstanceForTransformation(job.getCatalog());
        try {
            IndexingThread.translateContent(this._manager, new FlintErrorListener(this._listener, job), job.getIndex(), content, job.getParameters(), parser.getResult());
        }
        catch (IndexException ex) {
            this._listener.error(job, ex.getMessage(), ex);
            return false;
        }
        List<FlintDocument> documents = parser.getDocuments();
        if (documents == null || documents.isEmpty()) {
            this._listener.warn(job, "No Lucene Documents to Index!");
            return documents != null;
        }
        Collection<FlintField> fields = job.getIndex().getFields(content);
        if (fields != null && !fields.isEmpty()) {
            for (FlintDocument doc : documents) {
                for (FlintField field : fields) {
                    doc.removeFields(field.name());
                }
                for (FlintField field : fields) {
                    doc.add(field);
                }
            }
        }
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        try {
            if (!io.updateDocuments(content.getDeleteRule(), documents, this._listener, job)) {
                this._listener.warn(job, "Failed to add Lucene Documents to Index");
            }
        }
        catch (Exception ex) {
            this._listener.error(job, "Failed to add Lucene Documents to Index", ex);
            return false;
        }
        return true;
    }

    public static void translateContent(IndexManager manager, FlintErrorListener errorListener, Index index, Content content, Map<String, String> params, Result result) throws IndexException {
        Reader source;
        String mediatype = content.getMediaType();
        if (mediatype == null) {
            throw new IndexException("Media Type not found.", null);
        }
        ContentTranslator translator = manager.getTranslator(mediatype);
        try {
            source = translator.translate(content);
        }
        catch (IndexException ex) {
            throw new IndexException("Failed to translate Source content.", ex);
        }
        if (source == null) {
            throw new IndexException("Failed to translate Content as the Translator returned a null result.", null);
        }
        Templates templates = index.getTemplates(content.getContentType(), mediatype);
        if (templates == null) {
            throw new IndexException("Failed to load XSLT script for Content.", null);
        }
        try {
            Transformer t = templates.newTransformer();
            if (errorListener != null) {
                t.setErrorListener(errorListener);
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            Map<String, String> indexParams = index.getParameters(content);
            if (indexParams != null) {
                parameters.putAll(indexParams);
            }
            if (params != null) {
                parameters.putAll(params);
            }
            for (Map.Entry p : parameters.entrySet()) {
                t.setParameter((String)p.getKey(), p.getValue());
            }
            t.transform(new StreamSource(source), result);
        }
        catch (Exception ex) {
            throw new IndexException("Failed to create Index XML from Source content.", ex);
        }
        finally {
            try {
                source.close();
            }
            catch (IOException ex) {
                LOGGER.debug("Unable to close source", (Throwable)ex);
            }
        }
    }
}

