<!--
  ~ Copyright (c) 1999-2023. Allette Systems Pty Ltd
  -->

<!--
  Check xref, blockxref and reversexref
-->
<sch:pattern id="xref_checker" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <!-- Match cross references -->
  <sch:rule context="(xref[not(@external='true')]|blockxref)[not(ancestor::media-fragment)]">

    <!-- Cross references should not point to archived documents -->
    <sch:assert id="xref_archived" test="not(@archived='true')"
                properties="fragment" flag="warning"
    >Cross-reference &#x201C;<sch:value-of select="text()"/>&#x201D; points to
      <sch:value-of select="if (starts-with(@href,'/ps/archive/'))
          then 'a document in an archived group' else 'an archived document'"/>.</sch:assert>

    <!-- Cross references should resolve to an actual document -->
    <sch:assert id="xref_unresolved" test="not(@unresolved = 'true')"
                properties="fragment" flag="error"
    >Cross-reference &#x201C;<sch:value-of select="text()"/>&#x201D; is unresolved.</sch:assert>

  </sch:rule>

  <!-- Match reverse cross references -->
  <sch:rule context="(reversexref)[not(ancestor::media-fragment)]">

    <!-- Reverse cross references should not be from an archived documents -->
    <sch:assert id="reversexref_archived" test="not(@archived='true')"
                properties="fragment" flag="warning"
    >Incoming reference from archived document &#x201C;<sch:value-of select="@urititle"/>&#x201D;.</sch:assert>

  </sch:rule>

</sch:pattern>