<!--
  Find terms to in fragment text except code.

  The list of terms is defined in an external document using the
  `avoid` inline label.
-->
<sch:pattern id="terms_to_avoid" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
  <sch:title>Terms to avoid</sch:title>

  <!-- List of terms to avoid from the table in vocabulary document -->
  <sch:let name="avoid" value="document('/ps/[project]/[group]/vocabulary.psml')//inline[@label='avoid']"/>

  <!-- Sequence of terms -->
  <sch:let name="avoid-terms" value="
       for $i in $avoid
          return normalize-space(tokenize(replace($i, '\([^\)]+\)', ''), ','))"/>

  <!-- Regex to match terms to avoid -->
  <sch:let name="avoid-terms-regex" value="concat(
       '(^|\W)(', string-join(
          for $i in $avoid-terms
             return replace($i, '[.]', '\$1')
       , '|'), ')($|\W)')"/>

  <sch:rule context="section[not(@edit='false')]/fragment//* except (monospace|preformat)">

    <sch:assert test="not(some $i in text() satisfies matches($i, $avoid-terms-regex, 'im'))"
                id="terms_to_avoid_found"
                properties="fragment" flag="warning"
    >Found term(s) to avoid: <sch:value-of select="
        string-join(for $i in $avoid-terms
           return if (matches(., concat('(^|\W)',replace($i, '[.]', '\$1'), '($|\W)'), 'i'))
              then $i else (), ', ')"/>.
    </sch:assert>

  </sch:rule>

</sch:pattern>
