<!-- checks that plcaeholders resolve to publication metadata -->
<sch:pattern id="placeholder_checker" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <sch:let name="pub-roots" value="document('ps:search?filters=pspublicationroot:true&amp;pagesize=2000')" />
  
  <sch:let name="pubs" value="document('ps:publications')" />
  
  <sch:rule context="placeholder">
    
    <sch:let name="resolved-pubs"
             value="$pub-roots//result[field[@name='psmetadataname']=current()/@name]/field[@name='psid']/text()" />

    <sch:assert test="not($pubs//publication[not(@rooturiid=$resolved-pubs)])"
                id="placeholder_unresolved" flag="error" properties="fragment"
    >The placeholder "<sch:value-of select="@name"/>" can't be resolved for publication(s) <sch:value-of
     select="$pubs//publication[not(@rooturiid=$resolved-pubs)]/@id" />.</sch:assert>

  </sch:rule>

</sch:pattern>