<!--
  Checks for Sentence case capitalization

  In sentence case, most  words are lowercase (proper nouns are an exception in that they are always capitalized).
  major words: Nouns, verbs (including linking verbs), adjectives, adverbs, pronouns, and all words of four letters or more are considered major words.minor words: Short (i.e., three letters or fewer) conjunctions, short prepositions, and all articles are considered minor words.
  Sentence case capitalization is covered in Section 6.17 of the APA Publication Manual, Seventh Edition

  This guidance has been expanded from the 6th edition.
  How to implement sentence case
  In sentence case, lowercase most words in a title or heading.

  Capitalize only the following words:
   - the first word of the title or heading
   - the first word of a subtitle
   - the first word after a colon, em dash, or end punctuation in a heading
   - nouns followed by numerals or letters
   - proper nouns (such as the names of racial or ethnic groups)

  Use sentence case for the following: titles of articles, books, reports, webpages, and other works in reference list entries, even if title case was used in the original work
-->
<sch:pattern id="heading_sentence_case" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <!-- List of terms that should remain capitalized (acronyms, proper nouns, Roman numerals, etc.) -->
  <sch:let name="exceptions" value="('Australia', 'PDF', 'Sydney', 'URL')"/>

  <!-- TODO Roman numerals should remain in upper case
  <sch:let name="roman-numerals" value="('[IVXLCDM]+')"/>
  -->

  <!-- Regular expression to match the exceptions -->
  <sch:let name="exceptions-regex" value="concat('(', string-join($exceptions, '|'), ')')"/>

  <!-- Match any heading -->
  <sch:rule context="heading">

    <!-- Used to check capitalization rules -->
    <sch:let name="norm" value="string-join(for $i in tokenize(.,'\W+')
       return if (matches($i, $exceptions-regex)) then lower-case($i) else $i, ' ')"/>

    <!-- Heading SHOULD be capitalized correctly -->
    <sch:assert test="substring(., 1, 1) = upper-case(substring(., 1, 1))
                   and substring($norm, 2) = lower-case(substring($norm, 2))"
                id="heading_bad_case"
                properties="fragment" flag="tip"
    >A heading should use sentence case,
      but heading &#x201C;<sch:value-of select="."/>&#x201D; is not.</sch:assert>

  </sch:rule>

</sch:pattern>
