<!--
  Requires the path and filename to be in lower case.
-->
<sch:pattern id="filename_lowercase" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <sch:rule context="documentinfo/uri">

    <sch:let name="folder"   value="substring-before(@path, tokenize(@path, '/')[last()])"/>
    <sch:let name="filename" value="tokenize(@path, '/')[last()]"/>

    <!-- Folders SHOULD be in lower case -->
    <sch:assert test="$folder = lower-case($folder)"
                id="folder_lower_case"
    >All document folders MUST be in lower case.</sch:assert>

    <!-- Filenames SHOULD be in lower case -->
    <sch:report test="$filename != lower-case($filename)"
                id="filename_lower_case"
    >All document files SHOULD be in lower case</sch:report>

  </sch:rule>

</sch:pattern>
