<!--
  This pattern expects curly (typographical) quotation marks to be used in text
  but not code fragments.
-->
<sch:pattern id="code_quotes_curly" xmlns:sch="http://purl.oclc.org/dsdl/schematron">

  <!--
    Curly quotation marks:
    left single quote, right single quote, left double quote, right double quote
  -->
  <sch:let name="curly-quotes" value="'[&#x2018;&#x2019;&#x201C;&#x201D;]'"/>

  <sch:rule context="fragment//*[matches(text(), $curly-quotes, 'm')]">

    <sch:assert test="not(self::monospace|ancestor::monospace
                         |self::preformat|ancestor::preformat)"
                id="curly_quote_in_code"
                properties="fragment" flag="warning"
    >Found curly quotation mark in code. Use straight quotation marks instead.</sch:assert>

  </sch:rule>

</sch:pattern>