<!--
  Find terms to in fragment text except code.
-->
<sch:pattern id="block_captions" xmlns:sch="http://purl.oclc.org/dsdl/schematron">
  <sch:title>Captions using blocks</sch:title>

  <!-- Name of image caption bock label -->
  <sch:let name="image-caption" value="'image-caption'"/>

  <!-- Name of table caption bock label -->
  <sch:let name="table-caption" value="'table-caption'"/>

  <sch:rule context="para/image">
    <sch:assert test="preceding::block[@label=$image-caption][following-sibling::para/image/@src = current()/@src]"
                id="image_block_caption"
                properties="fragment"
    >Every image must be preceded by a image-caption block label</sch:assert>
  </sch:rule>

  <sch:rule context="table">
    <sch:assert test="preceding-sibling::block[@label=$table-caption][following-sibling::*[1] = current()]"
                id="table_block_caption"
                properties="fragment"
    >Every table must be preceded by a table-caption block label.</sch:assert>
  </sch:rule>

</sch:pattern>