Basic auto-numbered publication bundle
======================================

Version: 6.2002

To use this bundle follow these steps:

1. Install the bundle under the root document type for your publication (e.g. `references`).
2. **Set the publication type on your publication root document to `report`.**
3. Edit the `Export publication as custom DOCX` description in the `document-config.xml` to make it more specific.
4. To make a heading or paragraph auto-numbered, click the **(#) toggle autonumber** icon when editing.
5. To create user help, while previewing this document copy the headings/text below to your clip-board.
   Create a group named `help` under your project and create a document of type `help` in that group
   with title `Auto-numbered publication`. Edit this document and paste your clip-board content
   into the bottom fragment and in the keypoint block type `Special features of this publication`.
   In the **Document info** panel **Metadata** type the publication root document type (e.g. `references`),
   Press **Enter** and click **Save**. Now the content below will display to users when they click the **(?) help** icon.

Changing the auto-numbering scheme
----------------------------------

1. Edit the `@type` or `@format` attributes in the `publication-config.xml`.
   It can be accessed via the **Template configuration** page, under **Publication types**.
2. To apply appendix auto-numbering add the `appendix` label to your document in the **Document information** panel.
3. To add other auto-numbering schemes, duplicate the appendix `<numbering>` element
   in the `publication-config.xml` and change the `@document-label` attribute.
4. To troubleshoot auto-numbering issues select **Developer** layout in your **Preferences**,
   click the **(wrench) show numbering table** icon in the Table of contents,
   then click the **Document developer tools** icon (right margin) and **edit** next to Publication.
   After saving config edits, click **Back** and **Reload**, then click the **reload** icon on the Table of contents.

Inserting footnotes or endnotes
-------------------------------

Footnotes and endnotes are xrefs to fragments in a footnotes or endnotes document.
After being saved they should appear as an ‘f’ or ‘e’ followed by a unique number.
When the publication is exported to Word these will be replaced by the correct numbers calculated by Word.

1. Enter edit mode by double clicking on a paragraph in the document. 
2. Place the cursor in the text and select the insert XRef icon xref. 
3. Under **Configuration** select Footnote or Endnote.
4. If no Footnotes or Endnotes document appears, click the **browse icon**, then click **Create**.
5. After the Footnotes or Endnotes document appears click the **(pencil) edit icon** at the top of it. 
6. Mouse over the bottom of the Footnotes or Endnotes document and click the **(+) insert fragment** icon. 
7. Type some content text for the note and click **Create**. 
8. Click on the new fragment and then click **Save**. 
9. Press **Ctrl-S** then click the **(pencil) edit icon** (top right) to turn edit mode off.

Inserting math equations
------------------------

Equations can be inserted using [AsciiMath](http://asciimath.org/) or [TeX](https://en.wikibooks.org/wiki/LaTeX/Mathematics).

1. Enter edit mode by double clicking on a paragraph in the document.
2. Type the AsciiMath or Tex markup where you would like the equation.
3. Select the equation, right-click and select **Apply inline 'asciimath'** or **'tex'**. 
4. Wait until the draft saved (blue bar on left) appears (or click the **save fragment** icon),
   then select the **(eye) preview fragment** option from the ellipsis menu, to preview the equation.
5. Press **Ctrl-S** then click the **(pencil) edit icon** (top right) to turn edit mode off.

Inserting placeholders
----------------------

A placeholder is a marker for some simple text content that is repeated throughout the publication,
for example `[company name]`. These placeholders will be replaced by their corresponding actual value
in the publication metadata properties.

1. Enter edit mode by double clicking on a paragraph in the document. 
2. Place the cursor in the text and type `[[company name]]` and press space. 
3. Press **Ctrl-S** then click on another location in a paragraph. 
4. Type `[c` and click on the `[company name]` that appears.
   This will automatically add an existing placeholdler. 
5. Press **Ctrl-S** then click the edit icon pencil (top right) to turn edit mode off. 
6. A warning should appear next to the placeholders to indicate they have not been defined. 
7. Click the **(i) Document information** icon in the right margin. 
8. Click on the **Publication** tab and then on **Add property**. 
9. For Title enter *Company name* and for Value enter *ACME Pty Ltd* 
10. Click **Submit** then click **Save**.
11. Click the **`[iii]` Resolve placeholders** icon at the top
    and *ACME Pty Ltd* should appear in multiple places.

Inserting citations
-------------------

Citations are xrefs to citation fragments in a bibliography document.
After being saved they should appear as the citation Link text in brackets.
The bibliography document is designed as a quick way to add citations
without having to interrupt your writing to enter all the details.
Later you can find or create the correct source document.
Each citation fragment has a Source xref which points to a document in a source library.
The source library documents contain all the information required by Word
so that when the publication is exported they will appear as Word citations.
Word can then automatically format these citations in different styles, for example APA or Harvard.

1. Enter edit mode by double clicking on a paragraph in the document.
2. Place the cursor in the text and select the **(∞) insert xref** icon. 
3. Under **Configuration** select Citation. 
4. If no Bibliography document appears, click the **browse icon**, then click **Create**.
   Click **Cancel** and navigate to your publication root document, add the Bibliography document
   by typing in the xref box at the bottom and press **Ctrl-S** then go back to step 1.
5. After the Bibliography document appears click the **(pencil) edit icon** at the top of it. 
6. Scroll down, mouse over the bottom of the Bibliography document,
   click the **(+) insert fragment** icon and click Citation under it.
7. Enter Link text (for example *Jones, 2015*) and Description for the source, then click **Create**. 
8. Click on the new fragment and then click **Save**. 
9. Press **Ctrl-S** then click the edit icon pencil (top right) to turn edit mode off. 
10. Later to complete the citation, click the new citation xref and then double click on the source fragment to enter edit mode. 
11. Click the **browse document** icon next to **Source** and if the source is listed,
    click it and click **Select this document**, click **Save** then press **Ctrl-S** and you are done.
    Otherwise click the **browse document** icon at the top. 
12. Enter a Document title for the source, then click **Create**. 
13. Click on **Select this document** and then click **Save**. 
14. Press **Ctrl-S** then click the edit icon pencil (top right) to turn edit mode off. 
15. Click on the new source document and then edit it to fill in the details.